/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import se.llbit.nbt.ByteArrayTag;
import se.llbit.nbt.ByteTag;
import se.llbit.nbt.CompoundTag;
import se.llbit.nbt.DoubleTag;
import se.llbit.nbt.FloatTag;
import se.llbit.nbt.IntArrayTag;
import se.llbit.nbt.IntTag;
import se.llbit.nbt.ListTag;
import se.llbit.nbt.LongArrayTag;
import se.llbit.nbt.LongTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.ShortTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.StringTag;
import se.llbit.nbt.Tag;

public final class TagUtil {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpecificTag fromJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return new ByteTag(((Byte)number).byteValue());
                }
                if (number instanceof Short) {
                    return new ShortTag((Short)number);
                }
                if (number instanceof Integer) {
                    return new IntTag((Integer)number);
                }
                if (number instanceof Long) {
                    return new LongTag((Long)number);
                }
                if (number instanceof Float) {
                    return new FloatTag(((Float)number).floatValue());
                }
                if (!(number instanceof Double)) throw new IllegalArgumentException("Unknown JSON element: " + json);
                return new DoubleTag((Double)number);
            }
            if (jsonPrimitive.isString()) {
                return new StringTag(jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + jsonPrimitive);
            return new ByteTag(jsonPrimitive.getAsBoolean() ? 1 : 0);
        }
        if (json instanceof JsonObject) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<String, JsonElement> property : ((JsonObject)json).entrySet()) {
                compoundTag.add(property.getKey(), TagUtil.fromJson(property.getValue()));
            }
            return compoundTag;
        }
        if (json instanceof JsonArray) {
            void var2_10;
            List<JsonElement> jsonArray = ((JsonArray)json).asList();
            if (jsonArray.isEmpty()) {
                return new ListTag(0, Collections.emptyList());
            }
            int listType = TagUtil.fromJson(jsonArray.get(0)).tagType();
            switch (listType) {
                case 1: {
                    byte[] bytes = new byte[jsonArray.size()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (Byte)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                    }
                    ByteArrayTag byteArrayTag = new ByteArrayTag(bytes);
                    return var2_10;
                }
                case 3: {
                    int[] ints = new int[jsonArray.size()];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = (Integer)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                    }
                    IntArrayTag intArrayTag = new IntArrayTag(ints);
                    return var2_10;
                }
                case 4: {
                    long[] longs = new long[jsonArray.size()];
                    for (int i = 0; i < longs.length; ++i) {
                        longs[i] = (Long)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                    }
                    LongArrayTag longArrayTag = new LongArrayTag(longs);
                    return var2_10;
                }
                default: {
                    ArrayList<SpecificTag> tagItems = new ArrayList<SpecificTag>(jsonArray.size());
                    for (JsonElement jsonEl : jsonArray) {
                        SpecificTag subTag = TagUtil.fromJson(jsonEl);
                        if (!(subTag instanceof CompoundTag)) {
                            CompoundTag wrapper = new CompoundTag();
                            wrapper.add("", subTag);
                            subTag = wrapper;
                        }
                        tagItems.add(subTag);
                    }
                    ListTag listTag = new ListTag(listType, tagItems);
                }
            }
            return var2_10;
        }
        if (!(json instanceof JsonNull)) throw new IllegalArgumentException("Unknown JSON element: " + json);
        return Tag.END;
    }

    public static JsonElement toJson(SpecificTag tag) {
        switch (tag.tagType()) {
            case 1: {
                return new JsonPrimitive((byte)((ByteTag)tag).getData());
            }
            case 2: {
                return new JsonPrimitive(((ShortTag)tag).getData());
            }
            case 3: {
                return new JsonPrimitive(((IntTag)tag).getData());
            }
            case 4: {
                return new JsonPrimitive(((LongTag)tag).getData());
            }
            case 5: {
                return new JsonPrimitive(Float.valueOf(((FloatTag)tag).getData()));
            }
            case 6: {
                return new JsonPrimitive(((DoubleTag)tag).getData());
            }
            case 7: {
                byte[] byteArray = ((ByteArrayTag)tag).getData();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add(new JsonPrimitive(b));
                }
                return jsonByteArray;
            }
            case 8: {
                return new JsonPrimitive(((StringTag)tag).getData());
            }
            case 9: {
                List<SpecificTag> items = ((ListTag)tag).items;
                JsonArray jsonList = new JsonArray(items.size());
                for (SpecificTag subTag : items) {
                    SpecificTag first;
                    CompoundTag compound;
                    if (subTag instanceof CompoundTag && (compound = (CompoundTag)subTag).size() == 1 && !(first = (SpecificTag)compound.get("")).isError()) {
                        jsonList.add(TagUtil.toJson(first));
                        continue;
                    }
                    jsonList.add(TagUtil.toJson(subTag));
                }
                return jsonList;
            }
            case 10: {
                JsonObject jsonObject = new JsonObject();
                for (NamedTag subTag : (CompoundTag)tag) {
                    jsonObject.add(subTag.name(), TagUtil.toJson(subTag.getTag()));
                }
                return jsonObject;
            }
            case 11: {
                int[] intArray = ((IntArrayTag)tag).getData();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add(new JsonPrimitive(i));
                }
                return jsonIntArray;
            }
            case 12: {
                long[] longArray = ((LongArrayTag)tag).getData();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add(new JsonPrimitive(l));
                }
                return jsonLongArray;
            }
        }
        throw new IllegalArgumentException("Unknown NBT tag: " + tag);
    }

    private TagUtil() {
    }
}

