/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.ComponentStyleSerializer;

public class BaseComponentSerializer {
    protected void deserialize(JsonObject object, BaseComponent component, JsonDeserializationContext context) {
        JsonElement extra;
        JsonObject hoverEventJson;
        JsonObject clickEvent;
        component.applyStyle((ComponentStyle)context.deserialize(object, (Type)((Object)ComponentStyle.class)));
        JsonElement insertion = object.get("insertion");
        if (insertion != null) {
            component.setInsertion(insertion.getAsString());
        }
        if ((clickEvent = object.getAsJsonObject("clickEvent")) != null) {
            component.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf(clickEvent.get("action").getAsString().toUpperCase(Locale.ROOT)), clickEvent.has("value") ? clickEvent.get("value").getAsString() : ""));
        }
        if ((hoverEventJson = object.getAsJsonObject("hoverEvent")) != null) {
            HoverEvent hoverEvent = null;
            HoverEvent.Action action = HoverEvent.Action.valueOf(hoverEventJson.get("action").getAsString().toUpperCase(Locale.ROOT));
            JsonElement value = hoverEventJson.get("value");
            if (value != null) {
                BaseComponent[] components = value.isJsonArray() ? (BaseComponent[])context.deserialize(value, (Type)((Object)BaseComponent[].class)) : new BaseComponent[]{(BaseComponent)context.deserialize(value, (Type)((Object)BaseComponent.class))};
                hoverEvent = new HoverEvent(action, components);
            } else {
                JsonElement contents = hoverEventJson.get("contents");
                if (contents != null) {
                    Content[] list = contents.isJsonArray() ? (Content[])context.deserialize(contents, HoverEvent.getClass(action, true)) : new Content[]{(Content)context.deserialize(contents, HoverEvent.getClass(action, false))};
                    hoverEvent = new HoverEvent(action, new ArrayList<Content>(Arrays.asList(list)));
                }
            }
            if (hoverEvent != null) {
                component.setHoverEvent(hoverEvent);
            }
        }
        if ((extra = object.get("extra")) != null) {
            component.setExtra(Arrays.asList((BaseComponent[])context.deserialize(extra, (Type)((Object)BaseComponent[].class))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(JsonObject object, BaseComponent component, JsonSerializationContext context) {
        boolean first = false;
        if (ComponentSerializer.serializedComponents.get() == null) {
            first = true;
            ComponentSerializer.serializedComponents.set(Collections.newSetFromMap(new IdentityHashMap()));
        }
        try {
            Preconditions.checkArgument(!ComponentSerializer.serializedComponents.get().contains(component), "Component loop");
            ComponentSerializer.serializedComponents.get().add(component);
            ComponentStyleSerializer.serializeTo(component.getStyle(), object);
            if (component.getInsertion() != null) {
                object.addProperty("insertion", component.getInsertion());
            }
            if (component.getClickEvent() != null) {
                JsonObject clickEvent = new JsonObject();
                clickEvent.addProperty("action", component.getClickEvent().getAction().toString().toLowerCase(Locale.ROOT));
                clickEvent.addProperty("value", component.getClickEvent().getValue());
                object.add("clickEvent", clickEvent);
            }
            if (component.getHoverEvent() != null) {
                JsonObject hoverEvent = new JsonObject();
                hoverEvent.addProperty("action", component.getHoverEvent().getAction().toString().toLowerCase(Locale.ROOT));
                if (component.getHoverEvent().isLegacy()) {
                    hoverEvent.add("value", context.serialize(component.getHoverEvent().getContents().get(0)));
                } else {
                    hoverEvent.add("contents", context.serialize(component.getHoverEvent().getContents().size() == 1 ? component.getHoverEvent().getContents().get(0) : component.getHoverEvent().getContents()));
                }
                object.add("hoverEvent", hoverEvent);
            }
            if (component.getExtra() != null) {
                object.add("extra", context.serialize(component.getExtra()));
            }
        }
        finally {
            ComponentSerializer.serializedComponents.get().remove(component);
            if (first) {
                ComponentSerializer.serializedComponents.set(null);
            }
        }
    }
}

