/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Location;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.Tag;

public class Respawn
extends DefinedPacket {
    private Object dimension;
    private String worldName;
    private long seed;
    private short difficulty;
    private short gameMode;
    private short previousGameMode;
    private String levelType;
    private boolean debug;
    private boolean flat;
    private byte copyMeta;
    private Location deathLocation;
    private int portalCooldown;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            this.dimension = protocolVersion >= 1073742014 ? Integer.valueOf(Respawn.readVarInt(buf)) : (protocolVersion >= 751 && protocolVersion < 759 ? Respawn.readTag(buf, protocolVersion) : Respawn.readString(buf));
            this.worldName = Respawn.readString(buf);
        } else {
            this.dimension = buf.readInt();
        }
        if (protocolVersion >= 573) {
            this.seed = buf.readLong();
        }
        if (protocolVersion < 477) {
            this.difficulty = buf.readUnsignedByte();
        }
        this.gameMode = buf.readUnsignedByte();
        if (protocolVersion >= 735) {
            this.previousGameMode = buf.readUnsignedByte();
            this.debug = buf.readBoolean();
            this.flat = buf.readBoolean();
            if (protocolVersion < 764) {
                this.copyMeta = buf.readByte();
            }
        } else {
            this.levelType = Respawn.readString(buf);
        }
        if (protocolVersion >= 759 && buf.readBoolean()) {
            this.deathLocation = new Location(Respawn.readString(buf), buf.readLong());
        }
        if (protocolVersion >= 763) {
            this.portalCooldown = Respawn.readVarInt(buf);
        }
        if (protocolVersion >= 764) {
            this.copyMeta = buf.readByte();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            if (protocolVersion >= 1073742014) {
                Respawn.writeVarInt((Integer)this.dimension, buf);
            } else if (protocolVersion >= 751 && protocolVersion < 759) {
                Respawn.writeTag((Tag)this.dimension, buf, protocolVersion);
            } else {
                Respawn.writeString((String)this.dimension, buf);
            }
            Respawn.writeString(this.worldName, buf);
        } else {
            buf.writeInt((Integer)this.dimension);
        }
        if (protocolVersion >= 573) {
            buf.writeLong(this.seed);
        }
        if (protocolVersion < 477) {
            buf.writeByte(this.difficulty);
        }
        buf.writeByte(this.gameMode);
        if (protocolVersion >= 735) {
            buf.writeByte(this.previousGameMode);
            buf.writeBoolean(this.debug);
            buf.writeBoolean(this.flat);
            if (protocolVersion < 764) {
                buf.writeByte(this.copyMeta);
            }
        } else {
            Respawn.writeString(this.levelType, buf);
        }
        if (protocolVersion >= 759) {
            if (this.deathLocation != null) {
                buf.writeBoolean(true);
                Respawn.writeString(this.deathLocation.getDimension(), buf);
                buf.writeLong(this.deathLocation.getPos());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (protocolVersion >= 763) {
            Respawn.writeVarInt(this.portalCooldown, buf);
        }
        if (protocolVersion >= 764) {
            buf.writeByte(this.copyMeta);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public Object getDimension() {
        return this.dimension;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public long getSeed() {
        return this.seed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public short getPreviousGameMode() {
        return this.previousGameMode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public byte getCopyMeta() {
        return this.copyMeta;
    }

    public Location getDeathLocation() {
        return this.deathLocation;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setPreviousGameMode(short previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setCopyMeta(byte copyMeta) {
        this.copyMeta = copyMeta;
    }

    public void setDeathLocation(Location deathLocation) {
        this.deathLocation = deathLocation;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    @Override
    public String toString() {
        return "Respawn(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", levelType=" + this.getLevelType() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", copyMeta=" + this.getCopyMeta() + ", deathLocation=" + this.getDeathLocation() + ", portalCooldown=" + this.getPortalCooldown() + ")";
    }

    public Respawn() {
    }

    public Respawn(Object dimension, String worldName, long seed, short difficulty, short gameMode, short previousGameMode, String levelType, boolean debug, boolean flat, byte copyMeta, Location deathLocation, int portalCooldown) {
        this.dimension = dimension;
        this.worldName = worldName;
        this.seed = seed;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.levelType = levelType;
        this.debug = debug;
        this.flat = flat;
        this.copyMeta = copyMeta;
        this.deathLocation = deathLocation;
        this.portalCooldown = portalCooldown;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Respawn)) {
            return false;
        }
        Respawn other = (Respawn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.getCopyMeta() != other.getCopyMeta()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        Object this$dimension = this.getDimension();
        Object other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        Location this$deathLocation = this.getDeathLocation();
        Location other$deathLocation = other.getDeathLocation();
        return !(this$deathLocation == null ? other$deathLocation != null : !((Object)this$deathLocation).equals(other$deathLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Respawn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getGameMode();
        result = result * 59 + this.getPreviousGameMode();
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + this.getCopyMeta();
        result = result * 59 + this.getPortalCooldown();
        Object $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        Location $deathLocation = this.getDeathLocation();
        result = result * 59 + ($deathLocation == null ? 43 : ((Object)$deathLocation).hashCode());
        return result;
    }
}

