/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module.cmd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class CommandList
extends Command
implements TabExecutor {
    public CommandList() {
        super("glist", "bungeecord.command.list", new String[0]);
    }

    public void execute(CommandSender sender, String[] args) {
        boolean hideEmptyServers = args.length == 0 || !args[0].equalsIgnoreCase("all");
        for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
            if (!server.canAccess(sender)) continue;
            Collection serverPlayers = server.getPlayers();
            if (hideEmptyServers && serverPlayers.isEmpty()) continue;
            ArrayList<String> players = new ArrayList<String>();
            for (ProxiedPlayer player : serverPlayers) {
                players.add(player.getDisplayName());
            }
            Collections.sort(players, String.CASE_INSENSITIVE_ORDER);
            sender.sendMessage(ProxyServer.getInstance().getTranslation("command_list", new Object[]{server.getName(), players.size(), String.join((CharSequence)(ChatColor.RESET + ", "), players)}));
        }
        sender.sendMessage(ProxyServer.getInstance().getTranslation("total_players", new Object[]{ProxyServer.getInstance().getOnlineCount()}));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        return args.length > 1 ? Collections.emptyList() : Collections.singletonList("all");
    }
}

