/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ScoreboardDisplay
extends DefinedPacket {
    private int position;
    private String name;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.position = protocolVersion >= 1073741976 ? ScoreboardDisplay.readVarInt(buf) : (int)buf.readByte();
        this.name = ScoreboardDisplay.readString(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 1073741976) {
            ScoreboardDisplay.writeVarInt(this.position, buf);
        } else {
            buf.writeByte(this.position);
        }
        ScoreboardDisplay.writeString(this.name, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ScoreboardDisplay(position=" + this.getPosition() + ", name=" + this.getName() + ")";
    }

    public ScoreboardDisplay() {
    }

    public ScoreboardDisplay(int position, String name) {
        this.position = position;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreboardDisplay)) {
            return false;
        }
        ScoreboardDisplay other = (ScoreboardDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreboardDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

