/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.StringTag;
import se.llbit.nbt.Tag;

public class CompoundTag
extends SpecificTag
implements Iterable<NamedTag> {
    final List<NamedTag> items;

    public void add(String name, SpecificTag tag) {
        this.add(new NamedTag(name, tag));
    }

    public static SpecificTag read(DataInputStream in) {
        Tag last;
        CompoundTag tagThis = new CompoundTag();
        while (!(last = NamedTag.read(in)).isEnd()) {
            tagThis.add((NamedTag)last);
        }
        return tagThis;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        for (Tag tag : this.items) {
            tag.write(out);
        }
        out.writeByte(0);
    }

    static Map<String, Tag> partialParse(DataInputStream in, String prefix, Map<String, Tag> result, Set<String> request, Set<String> prefixes) {
        try {
            byte type;
            while ((type = in.readByte()) != 0) {
                SpecificTag name = StringTag.read(in);
                String tag = prefix + "." + name.stringValue();
                boolean parsed = NamedTag.partiallyParseTag(in, result, request, prefixes, type, tag);
                if (parsed) {
                    if (!request.isEmpty()) continue;
                    return result;
                }
                SpecificTag.skip(type, in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    static void skip(DataInputStream in) {
        try {
            byte itemType;
            while ((itemType = in.readByte()) != 0) {
                StringTag.skip(in);
                SpecificTag.skip(itemType, in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CompoundTag() {
        this.items = new ArrayList<NamedTag>();
    }

    @Override
    public void printTag(StringBuilder buff, String indent) {
        buff.append(indent);
        this.printTagInfo(buff);
        for (NamedTag tag : this.items) {
            buff.append(String.format("%s  %s:\n", indent, tag.name()));
            tag.tag.printTag(buff, indent + "    ");
        }
    }

    public CompoundTag(List<? extends NamedTag> items) {
        this.items = new ArrayList<NamedTag>(items);
    }

    public int size() {
        return this.items.size();
    }

    public void add(NamedTag node) {
        this.items.add(node);
    }

    @Override
    public String toString() {
        return this.dumpTree();
    }

    public String type() {
        return "TAG_Compound";
    }

    @Override
    public String tagName() {
        return "TAG_Compound";
    }

    @Override
    public int tagType() {
        return 10;
    }

    @Override
    public boolean isCompoundTag() {
        return true;
    }

    @Override
    public Tag get(String name) {
        for (Tag tag : this.items) {
            if (!tag.isNamed(name)) continue;
            return tag.unpack();
        }
        return new ErrorTag("No item named \"" + name + "\" in this compound tag.");
    }

    @Override
    public void set(String name, Tag tag) {
        throw new Error();
    }

    @Override
    public Iterator<NamedTag> iterator() {
        return this.items.iterator();
    }

    @Override
    public CompoundTag asCompound() {
        return this;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompoundTag)) {
            return false;
        }
        CompoundTag other = (CompoundTag)obj;
        for (NamedTag tag : this.items) {
            if (other.get(tag.name()).equals(tag.tag)) continue;
            return false;
        }
        for (NamedTag tag : other.items) {
            if (this.get(tag.name()).equals(tag.tag)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 0;
        for (NamedTag tag : this.items) {
            code ^= tag.hashCode();
        }
        return code;
    }
}

