/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class DoubleTag
extends SpecificTag {
    public final double value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new DoubleTag(in.readDouble());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Double:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeDouble(this.getData());
    }

    public DoubleTag(double value) {
        this.value = value;
    }

    public double getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Double";
    }

    @Override
    public String tagName() {
        return "TAG_Double";
    }

    @Override
    public int tagType() {
        return 6;
    }

    @Override
    public double doubleValue() {
        return this.getData();
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DoubleTag && ((DoubleTag)obj).value == this.value;
    }

    public int hashCode() {
        long x = Double.doubleToRawLongBits(this.value);
        return (int)(x >> 32 ^ x);
    }
}

