/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.score.Score;

public final class ChatComponentTransformer {
    private static final ChatComponentTransformer INSTANCE = new ChatComponentTransformer();
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("^@([pares])(?:\\[([^ ]*)\\])?$");

    public static ChatComponentTransformer getInstance() {
        return INSTANCE;
    }

    public BaseComponent[] transform(ProxiedPlayer player, BaseComponent ... component) {
        if (component == null || component.length < 1 || component.length == 1 && component[0] == null) {
            return new BaseComponent[]{new TextComponent("")};
        }
        for (BaseComponent root : component) {
            if (root.getExtra() != null && !root.getExtra().isEmpty()) {
                ArrayList<BaseComponent> list = Lists.newArrayList(this.transform(player, root.getExtra().toArray(new BaseComponent[root.getExtra().size()])));
                root.setExtra(list);
            }
            if (!(root instanceof ScoreComponent)) continue;
            this.transformScoreComponent(player, (ScoreComponent)root);
        }
        return component;
    }

    private void transformScoreComponent(ProxiedPlayer player, ScoreComponent component) {
        Score score;
        Preconditions.checkArgument(!this.isSelectorPattern(component.getName()), "Cannot transform entity selector patterns");
        if (component.getValue() != null && !component.getValue().isEmpty()) {
            return;
        }
        if (component.getName().equals("*")) {
            component.setName(player.getName());
        }
        if (player.getScoreboard().getObjective(component.getObjective()) != null && (score = player.getScoreboard().getScore(component.getName())) != null) {
            component.setValue(Integer.toString(score.getValue()));
        }
    }

    public boolean isSelectorPattern(String pattern) {
        return SELECTOR_PATTERN.matcher(pattern).matches();
    }

    private ChatComponentTransformer() {
    }
}

