/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.TabCompleteResponseEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Position;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.tab.TabList;

public class DownstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;

    @Override
    public void exception(Throwable t) throws Exception {
        if (this.server.isObsolete()) {
            return;
        }
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        if (def != null) {
            this.server.setObsolete(true);
            this.con.connectNow(def, ServerConnectEvent.Reason.SERVER_DOWN_REDIRECT);
            this.con.sendMessage(this.bungee.getTranslation("server_went_down", new Object[0]));
        } else {
            this.con.disconnect(Util.exception(t));
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        if (this.bungee.getReconnectHandler() != null) {
            this.bungee.getReconnectHandler().setServer(this.con);
        }
        if (!this.server.isObsolete()) {
            this.con.disconnect(this.bungee.getTranslation("lost_connection", new Object[0]));
        }
        ServerDisconnectEvent serverDisconnectEvent = new ServerDisconnectEvent(this.con, this.server.getInfo());
        this.bungee.getPluginManager().callEvent(serverDisconnectEvent);
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.server.isObsolete();
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        this.con.getEntityRewrite().rewriteClientbound(packet.buf, this.con.getServerEntityId(), this.con.getClientEntityId(), this.con.getPendingConnection().getVersion());
        this.con.sendPacket(packet);
    }

    @Override
    public void handle(KeepAlive alive) throws Exception {
        this.server.setSentPingId(alive.getRandomId());
        this.con.setSentPingTime(System.currentTimeMillis());
    }

    @Override
    public void handle(PlayerListItem playerList) throws Exception {
        this.con.getTabListHandler().onUpdate(TabList.rewrite(playerList));
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(ScoreboardObjective objective) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (objective.getAction()) {
            case 0: {
                serverScoreboard.addObjective(new Objective(objective.getName(), objective.getValue(), objective.getType().toString()));
                break;
            }
            case 1: {
                serverScoreboard.removeObjective(objective.getName());
                break;
            }
            case 2: {
                Objective oldObjective = serverScoreboard.getObjective(objective.getName());
                if (oldObjective == null) break;
                oldObjective.setValue(objective.getValue());
                oldObjective.setType(objective.getType().toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown objective action: " + objective.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardScore score) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (score.getAction()) {
            case 0: {
                Score s = new Score(score.getItemName(), score.getScoreName(), score.getValue());
                serverScoreboard.removeScore(score.getItemName());
                serverScoreboard.addScore(s);
                break;
            }
            case 1: {
                serverScoreboard.removeScore(score.getItemName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scoreboard action: " + score.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardDisplay displayScoreboard) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        serverScoreboard.setName(displayScoreboard.getName());
        serverScoreboard.setPosition(Position.values()[displayScoreboard.getPosition()]);
    }

    @Override
    public void handle(Team team) throws Exception {
        net.md_5.bungee.api.score.Team t;
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        if (team.getMode() == 1) {
            serverScoreboard.removeTeam(team.getName());
            return;
        }
        if (team.getMode() == 0) {
            t = new net.md_5.bungee.api.score.Team(team.getName());
            serverScoreboard.addTeam(t);
        } else {
            t = serverScoreboard.getTeam(team.getName());
        }
        if (t != null) {
            if (team.getMode() == 0 || team.getMode() == 2) {
                t.setDisplayName(team.getDisplayName());
                t.setPrefix(team.getPrefix());
                t.setSuffix(team.getSuffix());
                t.setFriendlyFire(team.getFriendlyFire());
                t.setNameTagVisibility(team.getNameTagVisibility());
                t.setCollisionRule(team.getCollisionRule());
                t.setColor(team.getColor());
            }
            if (team.getPlayers() != null) {
                for (String s : team.getPlayers()) {
                    if (team.getMode() == 0 || team.getMode() == 3) {
                        t.addPlayer(s);
                        continue;
                    }
                    if (team.getMode() != 4) continue;
                    t.removePlayer(s);
                }
            }
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        DataInput in = pluginMessage.getStream();
        PluginMessageEvent event = new PluginMessageEvent(this.server, this.con, pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals(this.con.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand")) {
            ByteBuf brand = Unpooled.wrappedBuffer(pluginMessage.getData());
            String serverBrand = DefinedPacket.readString(brand);
            brand.release();
            Preconditions.checkState(!serverBrand.contains(this.bungee.getName()), "Cannot connect proxy to itself!");
            brand = ByteBufAllocator.DEFAULT.heapBuffer();
            DefinedPacket.writeString(this.bungee.getName() + " (" + this.bungee.getVersion() + ") <- " + serverBrand, brand);
            pluginMessage.setData(DefinedPacket.toArray(brand));
            brand.release();
            this.con.unsafe().sendPacket(pluginMessage);
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("BungeeCord")) {
            byte[] b;
            ServerInfo info;
            ServerInfo server;
            ProxiedPlayer player;
            ServerInfo server2;
            byte[] payload;
            byte[] data;
            short len;
            String channel;
            Object target;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            String subChannel = in.readUTF();
            if (subChannel.equals("ForwardToPlayer")) {
                target = this.bungee.getPlayer(in.readUTF());
                if (target != null) {
                    channel = in.readUTF();
                    len = in.readShort();
                    data = new byte[len];
                    in.readFully(data);
                    out.writeUTF(channel);
                    out.writeShort(data.length);
                    out.write(data);
                    payload = out.toByteArray();
                    target.getServer().sendData("BungeeCord", payload);
                }
                out = null;
            }
            if (subChannel.equals("Forward")) {
                target = in.readUTF();
                channel = in.readUTF();
                len = in.readShort();
                data = new byte[len];
                in.readFully(data);
                out.writeUTF(channel);
                out.writeShort(data.length);
                out.write(data);
                payload = out.toByteArray();
                out = null;
                if (((String)target).equals("ALL")) {
                    for (ServerInfo server3 : this.bungee.getServers().values()) {
                        if (server3 == this.server.getInfo()) continue;
                        server3.sendData("BungeeCord", payload);
                    }
                } else if (((String)target).equals("ONLINE")) {
                    for (ServerInfo server3 : this.bungee.getServers().values()) {
                        if (server3 == this.server.getInfo()) continue;
                        server3.sendData("BungeeCord", payload, false);
                    }
                } else {
                    ServerInfo server4 = this.bungee.getServerInfo((String)target);
                    if (server4 != null) {
                        server4.sendData("BungeeCord", payload);
                    }
                }
            }
            if (subChannel.equals("Connect") && (server2 = this.bungee.getServerInfo(in.readUTF())) != null) {
                this.con.connect(server2, ServerConnectEvent.Reason.PLUGIN_MESSAGE);
            }
            if (subChannel.equals("ConnectOther") && (player = this.bungee.getPlayer(in.readUTF())) != null && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                player.connect(server);
            }
            if (subChannel.equals("IP")) {
                out.writeUTF("IP");
                out.writeUTF(this.con.getAddress().getHostString());
                out.writeInt(this.con.getAddress().getPort());
            }
            if (subChannel.equals("PlayerCount")) {
                target = in.readUTF();
                out.writeUTF("PlayerCount");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeInt(this.bungee.getOnlineCount());
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeInt(server.getPlayers().size());
                    }
                }
            }
            if (subChannel.equals("PlayerList")) {
                target = in.readUTF();
                out.writeUTF("PlayerList");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeUTF(Util.csv(this.bungee.getPlayers()));
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeUTF(Util.csv(server.getPlayers()));
                    }
                }
            }
            if (subChannel.equals("GetServers")) {
                out.writeUTF("GetServers");
                out.writeUTF(Util.csv(this.bungee.getServers().keySet()));
            }
            if (subChannel.equals("Message")) {
                target = in.readUTF();
                String message = in.readUTF();
                if (((String)target).equals("ALL")) {
                    for (ProxiedPlayer player2 : this.bungee.getPlayers()) {
                        player2.sendMessage(message);
                    }
                } else {
                    ProxiedPlayer player3 = this.bungee.getPlayer((String)target);
                    if (player3 != null) {
                        player3.sendMessage(message);
                    }
                }
            }
            if (subChannel.equals("GetServer")) {
                out.writeUTF("GetServer");
                out.writeUTF(this.server.getInfo().getName());
            }
            if (subChannel.equals("UUID")) {
                out.writeUTF("UUID");
                out.writeUTF(this.con.getUUID());
            }
            if (subChannel.equals("UUIDOther") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                out.writeUTF("UUIDOther");
                out.writeUTF(player.getName());
                out.writeUTF(player.getUUID());
            }
            if (subChannel.equals("ServerIP") && (info = this.bungee.getServerInfo(in.readUTF())) != null) {
                out.writeUTF("ServerIP");
                out.writeUTF(info.getName());
                out.writeUTF(info.getAddress().getAddress().getHostAddress());
                out.writeShort(info.getAddress().getPort());
            }
            if (subChannel.equals("KickPlayer") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                String kickReason = in.readUTF();
                player.disconnect((BaseComponent)new TextComponent(kickReason));
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.server.sendData("BungeeCord", b);
            }
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        ServerKickEvent event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, this.server.getInfo(), ComponentSerializer.parse(kick.getMessage()), def, ServerKickEvent.State.CONNECTED));
        if (event.isCancelled() && event.getCancelServer() != null) {
            this.con.connectNow(event.getCancelServer(), ServerConnectEvent.Reason.KICK_REDIRECT);
        } else {
            this.con.disconnect0(event.getKickReasonComponent());
        }
        this.server.setObsolete(true);
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(SetCompression setCompression) throws Exception {
        this.server.getCh().setCompressionThreshold(setCompression.getThreshold());
    }

    @Override
    public void handle(TabCompleteResponse tabCompleteResponse) throws Exception {
        if (tabCompleteResponse.getCommands() == null) {
            return;
        }
        TabCompleteResponseEvent tabCompleteResponseEvent = new TabCompleteResponseEvent(this.server, this.con, tabCompleteResponse.getCommands());
        if (!this.bungee.getPluginManager().callEvent(tabCompleteResponseEvent).isCancelled()) {
            this.con.unsafe().sendPacket(tabCompleteResponse);
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(BossBar bossBar) {
        switch (bossBar.getAction()) {
            case 0: {
                this.con.getSentBossBars().add(bossBar.getUuid());
                break;
            }
            case 1: {
                this.con.getSentBossBars().remove(bossBar.getUuid());
            }
        }
    }

    @Override
    public void handle(Respawn respawn) {
        this.con.setDimension(respawn.getDimension());
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

