/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.nbt.regionfile;

import com.flowpowered.nbt.Tag;
import com.flowpowered.nbt.stream.NBTInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;

public class SimpleRegionFileReader {
    private static int EXPECTED_VERSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tag<?>> readFile(File f) {
        ArrayList arrayList;
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(f, "r");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            int i;
            int version = raf.readInt();
            if (version != EXPECTED_VERSION) {
                List<Tag<?>> list = null;
                return list;
            }
            int segmentSize = raf.readInt();
            int segmentMask = (1 << segmentSize) - 1;
            int entries = raf.readInt();
            ArrayList list = new ArrayList(entries);
            int[] blockSegmentStart = new int[entries];
            int[] blockActualLength = new int[entries];
            for (i = 0; i < entries; ++i) {
                blockSegmentStart[i] = raf.readInt();
                blockActualLength[i] = raf.readInt();
            }
            for (i = 0; i < entries; ++i) {
                if (blockActualLength[i] == 0) {
                    list.add(null);
                    continue;
                }
                byte[] data = new byte[blockActualLength[i]];
                raf.seek(blockSegmentStart[i] << segmentSize);
                raf.readFully(data);
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                InflaterInputStream iis = new InflaterInputStream(in);
                NBTInputStream ns = new NBTInputStream(iis, false);
                try {
                    Tag t = ns.readTag();
                    list.add(t);
                }
                catch (IOException ioe) {
                    list.add(null);
                }
                try {
                    ns.close();
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            arrayList = list;
        }
        catch (IOException ioe) {
            List<Tag<?>> list = null;
            return list;
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ioe) {}
        }
        return arrayList;
    }
}

