/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectEvent;

public class ServerConnectRequest {
    @NonNull
    private final ServerInfo target;
    @NonNull
    private final ServerConnectEvent.Reason reason;
    private final Callback<Result> result;
    private final int connectTimeout;
    private final boolean retry;

    @ConstructorProperties(value={"target", "reason", "result", "connectTimeout", "retry"})
    ServerConnectRequest(@NonNull ServerInfo target, @NonNull ServerConnectEvent.Reason reason, Callback<Result> result, int connectTimeout, boolean retry) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (reason == null) {
            throw new NullPointerException("reason");
        }
        this.target = target;
        this.reason = reason;
        this.result = result;
        this.connectTimeout = connectTimeout;
        this.retry = retry;
    }

    public static ServerConnectRequestBuilder builder() {
        return new ServerConnectRequestBuilder();
    }

    @NonNull
    public ServerInfo getTarget() {
        return this.target;
    }

    @NonNull
    public ServerConnectEvent.Reason getReason() {
        return this.reason;
    }

    public Callback<Result> getResult() {
        return this.result;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public static class ServerConnectRequestBuilder {
        private ServerInfo target;
        private ServerConnectEvent.Reason reason;
        private boolean retry;
        private Callback<Result> result;
        private int connectTimeout = 5000;

        @Deprecated
        public ServerConnectRequestBuilder callback(final Callback<Boolean> callback) {
            this.result = new Callback<Result>(){

                @Override
                public void done(Result result, Throwable error) {
                    callback.done(result == Result.SUCCESS ? Boolean.TRUE : Boolean.FALSE, error);
                }
            };
            return this;
        }

        ServerConnectRequestBuilder() {
        }

        public ServerConnectRequestBuilder target(ServerInfo target) {
            this.target = target;
            return this;
        }

        public ServerConnectRequestBuilder reason(ServerConnectEvent.Reason reason) {
            this.reason = reason;
            return this;
        }

        public ServerConnectRequestBuilder result(Callback<Result> result) {
            this.result = result;
            return this;
        }

        public ServerConnectRequestBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ServerConnectRequestBuilder retry(boolean retry) {
            this.retry = retry;
            return this;
        }

        public ServerConnectRequest build() {
            return new ServerConnectRequest(this.target, this.reason, this.result, this.connectTimeout, this.retry);
        }

        public String toString() {
            return "ServerConnectRequest.ServerConnectRequestBuilder(target=" + this.target + ", reason=" + (Object)((Object)this.reason) + ", result=" + this.result + ", connectTimeout=" + this.connectTimeout + ", retry=" + this.retry + ")";
        }
    }

    public static enum Result {
        EVENT_CANCEL,
        ALREADY_CONNECTED,
        ALREADY_CONNECTING,
        SUCCESS,
        FAIL;

    }
}

