/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteResponse
extends DefinedPacket {
    private int transactionId;
    private int start;
    private int length;
    private List<CommandMatch> matches;
    private List<String> commands;

    public TabCompleteResponse(int transactionId, int start, int length, List<CommandMatch> matches) {
        this.transactionId = transactionId;
        this.start = start;
        this.length = length;
        this.matches = matches;
    }

    public TabCompleteResponse(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 389) {
            this.transactionId = TabCompleteResponse.readVarInt(buf);
            this.start = TabCompleteResponse.readVarInt(buf);
            this.length = TabCompleteResponse.readVarInt(buf);
            int cnt = TabCompleteResponse.readVarInt(buf);
            this.matches = new LinkedList<CommandMatch>();
            for (int i = 0; i < cnt; ++i) {
                String match = TabCompleteResponse.readString(buf);
                String tooltip = buf.readBoolean() ? TabCompleteResponse.readString(buf) : null;
                this.matches.add(new CommandMatch(match, tooltip));
            }
        }
        if (protocolVersion < 389) {
            this.commands = TabCompleteResponse.readStringArray(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 389) {
            TabCompleteResponse.writeVarInt(this.transactionId, buf);
            TabCompleteResponse.writeVarInt(this.start, buf);
            TabCompleteResponse.writeVarInt(this.length, buf);
            TabCompleteResponse.writeVarInt(this.matches.size(), buf);
            for (CommandMatch match : this.matches) {
                TabCompleteResponse.writeString(match.match, buf);
                buf.writeBoolean(match.tooltip != null);
                TabCompleteResponse.writeString(match.tooltip, buf);
            }
        }
        if (protocolVersion < 389) {
            TabCompleteResponse.writeStringArray(this.commands, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public List<CommandMatch> getMatches() {
        return this.matches;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMatches(List<CommandMatch> matches) {
        this.matches = matches;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public String toString() {
        return "TabCompleteResponse(transactionId=" + this.getTransactionId() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", matches=" + this.getMatches() + ", commands=" + this.getCommands() + ")";
    }

    public TabCompleteResponse() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabCompleteResponse)) {
            return false;
        }
        TabCompleteResponse other = (TabCompleteResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        List<CommandMatch> this$matches = this.getMatches();
        List<CommandMatch> other$matches = other.getMatches();
        if (this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabCompleteResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getLength();
        List<CommandMatch> $matches = this.getMatches();
        result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public static class CommandMatch {
        private String match;
        private String tooltip;

        public String getMatch() {
            return this.match;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setMatch(String match) {
            this.match = match;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandMatch)) {
                return false;
            }
            CommandMatch other = (CommandMatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$match = this.getMatch();
            String other$match = other.getMatch();
            if (this$match == null ? other$match != null : !this$match.equals(other$match)) {
                return false;
            }
            String this$tooltip = this.getTooltip();
            String other$tooltip = other.getTooltip();
            return !(this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandMatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $match = this.getMatch();
            result = result * 59 + ($match == null ? 43 : $match.hashCode());
            String $tooltip = this.getTooltip();
            result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
            return result;
        }

        public String toString() {
            return "TabCompleteResponse.CommandMatch(match=" + this.getMatch() + ", tooltip=" + this.getTooltip() + ")";
        }

        public CommandMatch() {
        }

        @ConstructorProperties(value={"match", "tooltip"})
        public CommandMatch(String match, String tooltip) {
            this.match = match;
            this.tooltip = tooltip;
        }
    }
}

