/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityFlying;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityGhast
extends EntityFlying
implements IMonster {
    public int a = 0;
    public double b;
    public double c;
    public double d;
    private Entity target = null;
    private int h = 0;
    public int e = 0;
    public int f = 0;

    public EntityGhast(World world) {
        super(world);
        this.texture = "/mob/ghast.png";
        this.a(4.0f, 4.0f);
        this.fireProof = true;
        this.aV = 5;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if ("fireball".equals(damageSource.l()) && damageSource.getEntity() instanceof EntityHuman) {
            super.damageEntity(damageSource, 1000);
            ((EntityHuman)damageSource.getEntity()).a(AchievementList.y);
            return true;
        }
        return super.damageEntity(damageSource, n);
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, (byte)0);
    }

    public int getMaxHealth() {
        return 10;
    }

    public void h_() {
        super.h_();
        byte by = this.datawatcher.getByte(16);
        this.texture = by == 1 ? "/mob/ghast_fire.png" : "/mob/ghast.png";
    }

    protected void be() {
        byte by;
        byte by2;
        if (!this.world.isStatic && this.world.difficulty == 0) {
            this.die();
        }
        this.bb();
        this.e = this.f;
        double d = this.b - this.locX;
        double d2 = this.c - this.locY;
        double d3 = this.d - this.locZ;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 < 1.0 || d4 > 3600.0) {
            this.b = this.locX + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.c = this.locY + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.d = this.locZ + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.a-- <= 0) {
            this.a += this.random.nextInt(5) + 2;
            if (this.a(this.b, this.c, this.d, d4 = (double)MathHelper.sqrt(d4))) {
                this.motX += d / d4 * 0.1;
                this.motY += d2 / d4 * 0.1;
                this.motZ += d3 / d4 * 0.1;
            } else {
                this.b = this.locX;
                this.c = this.locY;
                this.d = this.locZ;
            }
        }
        if (this.target != null && this.target.dead) {
            this.target = null;
        }
        if (this.target == null || this.h-- <= 0) {
            this.target = this.world.findNearbyVulnerablePlayer(this, 100.0);
            if (this.target != null) {
                this.h = 20;
            }
        }
        double d5 = 64.0;
        if (this.target != null && this.target.e(this) < d5 * d5) {
            double d6 = this.target.locX - this.locX;
            double d7 = this.target.boundingBox.b + (double)(this.target.length / 2.0f) - (this.locY + (double)(this.length / 2.0f));
            double d8 = this.target.locZ - this.locZ;
            this.aq = this.yaw = -((float)Math.atan2(d6, d8)) * 180.0f / (float)Math.PI;
            if (this.l(this.target)) {
                if (this.f == 10) {
                    this.world.a(null, 1007, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                }
                ++this.f;
                if (this.f == 20) {
                    this.world.a(null, 1008, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                    EntityFireball entityFireball = new EntityFireball(this.world, this, d6, d7, d8);
                    double d9 = 4.0;
                    Vec3D vec3D = this.i(1.0f);
                    entityFireball.locX = this.locX + vec3D.a * d9;
                    entityFireball.locY = this.locY + (double)(this.length / 2.0f) + 0.5;
                    entityFireball.locZ = this.locZ + vec3D.c * d9;
                    this.world.addEntity(entityFireball);
                    this.f = -40;
                }
            } else if (this.f > 0) {
                --this.f;
            }
        } else {
            this.aq = this.yaw = -((float)Math.atan2(this.motX, this.motZ)) * 180.0f / (float)Math.PI;
            if (this.f > 0) {
                --this.f;
            }
        }
        if (!this.world.isStatic && (by2 = this.datawatcher.getByte(16)) != (by = (byte)(this.f > 10 ? 1 : 0))) {
            this.datawatcher.watch(16, by);
        }
    }

    private boolean a(double d, double d2, double d3, double d4) {
        double d5 = (this.b - this.locX) / d4;
        double d6 = (this.c - this.locY) / d4;
        double d7 = (this.d - this.locZ) / d4;
        AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
        int n = 1;
        while ((double)n < d4) {
            axisAlignedBB.d(d5, d6, d7);
            if (!this.world.getCubes(this, axisAlignedBB).isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected String aQ() {
        return "mob.ghast.moan";
    }

    protected String aR() {
        return "mob.ghast.scream";
    }

    protected String aS() {
        return "mob.ghast.death";
    }

    protected int getLootId() {
        return Item.SULPHUR.id;
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3 = this.random.nextInt(2) + this.random.nextInt(1 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.GHAST_TEAR.id, 1);
        }
        n3 = this.random.nextInt(3) + this.random.nextInt(1 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.SULPHUR.id, 1);
        }
    }

    protected float aP() {
        return 10.0f;
    }

    public boolean canSpawn() {
        return this.random.nextInt(20) == 0 && super.canSpawn() && this.world.difficulty > 0;
    }

    public int bl() {
        return 1;
    }
}

