/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockDirectional;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public class BlockDiode
extends BlockDirectional {
    public static final double[] a = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] b = new int[]{1, 2, 3, 4};
    private final boolean c;

    protected BlockDiode(int n, boolean bl) {
        super(n, 6, Material.ORIENTABLE);
        this.c = bl;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean c() {
        return false;
    }

    public boolean canPlace(World world, int n, int n2, int n3) {
        if (!world.t(n, n2 - 1, n3)) {
            return false;
        }
        return super.canPlace(world, n, n2, n3);
    }

    public boolean d(World world, int n, int n2, int n3) {
        if (!world.t(n, n2 - 1, n3)) {
            return false;
        }
        return super.d(world, n, n2, n3);
    }

    public void b(World world, int n, int n2, int n3, Random random) {
        int n4 = world.getData(n, n2, n3);
        boolean bl = this.e(world, n, n2, n3, n4);
        if (this.c && !bl) {
            world.setTypeIdAndData(n, n2, n3, Block.DIODE_OFF.id, n4);
        } else if (!this.c) {
            world.setTypeIdAndData(n, n2, n3, Block.DIODE_ON.id, n4);
            if (!bl) {
                int n5 = (n4 & 0xC) >> 2;
                world.a(n, n2, n3, Block.DIODE_ON.id, b[n5] * 2);
            }
        }
    }

    public int a(int n, int n2) {
        if (n == 0) {
            if (this.c) {
                return 99;
            }
            return 115;
        }
        if (n == 1) {
            if (this.c) {
                return 147;
            }
            return 131;
        }
        return 5;
    }

    public int b() {
        return 15;
    }

    public int a(int n) {
        return this.a(n, 0);
    }

    public boolean c(World world, int n, int n2, int n3, int n4) {
        return this.a((IBlockAccess)world, n, n2, n3, n4);
    }

    public boolean a(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        if (!this.c) {
            return false;
        }
        int n5 = BlockDiode.d(iBlockAccess.getData(n, n2, n3));
        if (n5 == 0 && n4 == 3) {
            return true;
        }
        if (n5 == 1 && n4 == 4) {
            return true;
        }
        if (n5 == 2 && n4 == 2) {
            return true;
        }
        return n5 == 3 && n4 == 5;
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (!this.d(world, n, n2, n3)) {
            this.c(world, n, n2, n3, world.getData(n, n2, n3), 0);
            world.setTypeId(n, n2, n3, 0);
            world.applyPhysics(n + 1, n2, n3, this.id);
            world.applyPhysics(n - 1, n2, n3, this.id);
            world.applyPhysics(n, n2, n3 + 1, this.id);
            world.applyPhysics(n, n2, n3 - 1, this.id);
            world.applyPhysics(n, n2 - 1, n3, this.id);
            world.applyPhysics(n, n2 + 1, n3, this.id);
            return;
        }
        int n5 = world.getData(n, n2, n3);
        boolean bl = this.e(world, n, n2, n3, n5);
        int n6 = (n5 & 0xC) >> 2;
        if (this.c && !bl || !this.c && bl) {
            world.a(n, n2, n3, this.id, b[n6] * 2);
        }
    }

    private boolean e(World world, int n, int n2, int n3, int n4) {
        int n5 = BlockDiode.d(n4);
        switch (n5) {
            case 0: {
                return world.isBlockFaceIndirectlyPowered(n, n2, n3 + 1, 3) || world.getTypeId(n, n2, n3 + 1) == Block.REDSTONE_WIRE.id && world.getData(n, n2, n3 + 1) > 0;
            }
            case 2: {
                return world.isBlockFaceIndirectlyPowered(n, n2, n3 - 1, 2) || world.getTypeId(n, n2, n3 - 1) == Block.REDSTONE_WIRE.id && world.getData(n, n2, n3 - 1) > 0;
            }
            case 3: {
                return world.isBlockFaceIndirectlyPowered(n + 1, n2, n3, 5) || world.getTypeId(n + 1, n2, n3) == Block.REDSTONE_WIRE.id && world.getData(n + 1, n2, n3) > 0;
            }
            case 1: {
                return world.isBlockFaceIndirectlyPowered(n - 1, n2, n3, 4) || world.getTypeId(n - 1, n2, n3) == Block.REDSTONE_WIRE.id && world.getData(n - 1, n2, n3) > 0;
            }
        }
        return false;
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        int n5 = world.getData(n, n2, n3);
        int n6 = (n5 & 0xC) >> 2;
        n6 = n6 + 1 << 2 & 0xC;
        world.setData(n, n2, n3, n6 | n5 & 3);
        return true;
    }

    public boolean isPowerSource() {
        return true;
    }

    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving) {
        int n4 = ((MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
        world.setData(n, n2, n3, n4);
        boolean bl = this.e(world, n, n2, n3, n4);
        if (bl) {
            world.a(n, n2, n3, this.id, 1);
        }
    }

    public void onPlace(World world, int n, int n2, int n3) {
        world.applyPhysics(n + 1, n2, n3, this.id);
        world.applyPhysics(n - 1, n2, n3, this.id);
        world.applyPhysics(n, n2, n3 + 1, this.id);
        world.applyPhysics(n, n2, n3 - 1, this.id);
        world.applyPhysics(n, n2 - 1, n3, this.id);
        world.applyPhysics(n, n2 + 1, n3, this.id);
    }

    public void postBreak(World world, int n, int n2, int n3, int n4) {
        if (this.c) {
            world.applyPhysics(n + 1, n2, n3, this.id);
            world.applyPhysics(n - 1, n2, n3, this.id);
            world.applyPhysics(n, n2, n3 + 1, this.id);
            world.applyPhysics(n, n2, n3 - 1, this.id);
            world.applyPhysics(n, n2 - 1, n3, this.id);
            world.applyPhysics(n, n2 + 1, n3, this.id);
        }
        super.postBreak(world, n, n2, n3, n4);
    }

    public boolean d() {
        return false;
    }

    public int getDropType(int n, Random random, int n2) {
        return Item.DIODE.id;
    }
}

