/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.util.internal.PlatformDependent;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.PlayerSkinConfiguration;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.SkinConfiguration;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.forge.ForgeClientHandler;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.tab.ServerUnique;
import net.md_5.bungee.tab.TabList;
import net.md_5.bungee.util.CaseInsensitiveSet;

public final class UserConnection
implements ProxiedPlayer {
    @NonNull
    private final ProxyServer bungee;
    @NonNull
    private final ChannelWrapper ch;
    @NonNull
    private final String name;
    private final InitialHandler pendingConnection;
    private ServerConnection server;
    private int dimension;
    private boolean dimensionChange = true;
    private final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();
    private int sentPingId;
    private long sentPingTime;
    private int ping = 100;
    private ServerInfo reconnectServer;
    private TabList tabListHandler;
    private int gamemode;
    private int compressionThreshold = -1;
    private Queue<String> serverJoinQueue;
    private final Collection<String> groups = new CaseInsensitiveSet();
    private final Collection<String> permissions = new CaseInsensitiveSet();
    private int clientEntityId;
    private int serverEntityId;
    private ClientSettings settings;
    private final Scoreboard serverSentScoreboard = new Scoreboard();
    private final Collection<UUID> sentBossBars = new HashSet<UUID>();
    private String displayName;
    private EntityMap entityRewrite;
    private Locale locale;
    private ForgeClientHandler forgeClientHandler;
    private ForgeServerHandler forgeServerHandler;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            UserConnection.this.ch.write(packet);
        }
    };
    private static final String EMPTY_TEXT = ComponentSerializer.toString((BaseComponent)new TextComponent(""));

    public void init() {
        this.entityRewrite = EntityMap.getEntityMap(this.getPendingConnection().getVersion());
        this.displayName = this.name;
        this.tabListHandler = new ServerUnique(this);
        Collection<String> g = this.bungee.getConfigurationAdapter().getGroups(this.name);
        g.addAll(this.bungee.getConfigurationAdapter().getGroups(this.getUniqueId().toString()));
        for (String s : g) {
            this.addGroups(s);
        }
        this.forgeClientHandler = new ForgeClientHandler(this);
        this.forgeClientHandler.setFmlTokenInHandshake(this.getPendingConnection().getExtraDataInHandshake().contains("\u0000FML\u0000"));
    }

    public void sendPacket(PacketWrapper packet) {
        this.ch.write(packet);
    }

    @Deprecated
    public boolean isActive() {
        return !this.ch.isClosed();
    }

    @Override
    public void setDisplayName(String name) {
        Preconditions.checkNotNull(name, "displayName");
        this.displayName = name;
    }

    @Override
    public void connect(ServerInfo target) {
        this.connect(target, null);
    }

    @Override
    public void connect(ServerInfo target, Callback<Boolean> callback) {
        this.connect(target, callback, false);
    }

    public void connectNow(ServerInfo target) {
        this.dimensionChange = true;
        this.connect(target);
    }

    public ServerInfo updateAndGetNextServer(ServerInfo currentTarget) {
        if (this.serverJoinQueue == null) {
            this.serverJoinQueue = new LinkedList<String>(this.getPendingConnection().getListener().getServerPriority());
        }
        ServerInfo next = null;
        while (!this.serverJoinQueue.isEmpty()) {
            ServerInfo candidate = ProxyServer.getInstance().getServerInfo(this.serverJoinQueue.remove());
            if (Objects.equal(currentTarget, candidate)) continue;
            next = candidate;
            break;
        }
        return next;
    }

    public void connect(ServerInfo info, final Callback<Boolean> callback, final boolean retry) {
        Preconditions.checkNotNull(info, "info");
        ServerConnectEvent event = new ServerConnectEvent(this, info);
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            if (callback != null) {
                callback.done(false, null);
            }
            if (this.getServer() == null && !this.ch.isClosing()) {
                throw new IllegalStateException("Cancelled ServerConnectEvent with no server or disconnect.");
            }
            return;
        }
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equal(this.getServer().getInfo(), target)) {
            if (callback != null) {
                callback.done(false, null);
            }
            this.sendMessage(this.bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (this.pendingConnects.contains(target)) {
            if (callback != null) {
                callback.done(false, null);
            }
            this.sendMessage(this.bungee.getTranslation("already_connecting", new Object[0]));
            return;
        }
        this.pendingConnects.add(target);
        ChannelInitializer initializer = new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().addAfter("frame-decoder", "packet-decoder", new MinecraftDecoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ch.pipeline().addAfter("frame-prepender", "packet-encoder", new MinecraftEncoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ch.pipeline().get(HandlerBoss.class).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (callback != null) {
                    callback.done(future.isSuccess(), future.cause());
                }
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = UserConnection.this.updateAndGetNextServer(target);
                    if (retry && def != null && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_lobby", new Object[0]));
                        UserConnection.this.connect(def, null, true);
                    } else if (UserConnection.this.dimensionChange) {
                        UserConnection.this.disconnect(UserConnection.this.bungee.getTranslation("fallback_kick", future.cause().getClass().getName()));
                    } else {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_kick", future.cause().getClass().getName()));
                    }
                }
            }
        };
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel())).group(this.ch.getHandle().eventLoop())).handler(initializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).remoteAddress(target.getAddress());
        if (this.getPendingConnection().getListener().isSetLocalAddress() && !PlatformDependent.isWindows()) {
            b.localAddress(this.getPendingConnection().getListener().getHost().getHostString(), 0);
        }
        b.connect().addListener(listener);
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect0(TextComponent.fromLegacyText(reason));
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        this.disconnect0(reason);
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect0(reason);
    }

    public void disconnect0(BaseComponent ... reason) {
        if (!this.ch.isClosing()) {
            this.bungee.getLogger().log(Level.INFO, "[{0}] disconnected with: {1}", new Object[]{this.getName(), BaseComponent.toLegacyText(reason)});
            this.ch.delayedClose(new Kick(ComponentSerializer.toString(reason)));
            if (this.server != null) {
                this.server.setObsolete(true);
                this.server.disconnect("Quitting");
            }
        }
    }

    @Override
    public void chat(String message) {
        Preconditions.checkState(this.server != null, "Not connected to server");
        this.server.getCh().write(new Chat(message));
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(TextComponent.fromLegacyText(message));
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(BaseComponent ... message) {
        this.sendMessage(ChatMessageType.CHAT, message);
    }

    @Override
    public void sendMessage(BaseComponent message) {
        this.sendMessage(ChatMessageType.CHAT, message);
    }

    private void sendMessage(ChatMessageType position, String message) {
        this.unsafe().sendPacket(new Chat(message, (byte)position.ordinal()));
    }

    @Override
    public void sendMessage(ChatMessageType position, BaseComponent ... message) {
        if (position == ChatMessageType.ACTION_BAR) {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent)new TextComponent(BaseComponent.toLegacyText(message))));
        } else {
            this.sendMessage(position, ComponentSerializer.toString(message));
        }
    }

    @Override
    public void sendMessage(ChatMessageType position, BaseComponent message) {
        if (position == ChatMessageType.ACTION_BAR) {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent)new TextComponent(BaseComponent.toLegacyText(message))));
        } else {
            this.sendMessage(position, ComponentSerializer.toString(message));
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.unsafe().sendPacket(new PluginMessage(channel, data, this.forgeClientHandler.isForgeUser()));
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.ch.getRemoteAddress();
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    @Override
    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.bungee.getPluginManager().callEvent(new PermissionCheckEvent(this, permission, this.permissions.contains(permission))).hasPermission();
    }

    @Override
    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    @Override
    public Collection<String> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public String getUUID() {
        return this.getPendingConnection().getUUID();
    }

    @Override
    public UUID getUniqueId() {
        return this.getPendingConnection().getUniqueId();
    }

    public void setSettings(ClientSettings settings) {
        this.settings = settings;
        this.locale = null;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null && this.settings != null ? (this.locale = Locale.forLanguageTag(this.settings.getLocale().replaceAll("_", "-"))) : this.locale;
    }

    @Override
    public byte getViewDistance() {
        return this.settings != null ? this.settings.getViewDistance() : (byte)10;
    }

    @Override
    public ProxiedPlayer.ChatMode getChatMode() {
        if (this.settings == null) {
            return ProxiedPlayer.ChatMode.SHOWN;
        }
        switch (this.settings.getChatFlags()) {
            default: {
                return ProxiedPlayer.ChatMode.SHOWN;
            }
            case 1: {
                return ProxiedPlayer.ChatMode.COMMANDS_ONLY;
            }
            case 2: 
        }
        return ProxiedPlayer.ChatMode.HIDDEN;
    }

    @Override
    public boolean hasChatColors() {
        return this.settings == null || this.settings.isChatColours();
    }

    @Override
    public SkinConfiguration getSkinParts() {
        return this.settings != null ? new PlayerSkinConfiguration(this.settings.getSkinParts()) : PlayerSkinConfiguration.SKIN_SHOW_ALL;
    }

    @Override
    public ProxiedPlayer.MainHand getMainHand() {
        return this.settings != null && this.settings.getMainHand() == 1 ? ProxiedPlayer.MainHand.RIGHT : ProxiedPlayer.MainHand.LEFT;
    }

    @Override
    public boolean isForgeUser() {
        return this.forgeClientHandler.isForgeUser();
    }

    @Override
    public Map<String, String> getModList() {
        if (this.forgeClientHandler.getClientModList() == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.forgeClientHandler.getClientModList());
    }

    @Override
    public void setTabHeader(BaseComponent header, BaseComponent footer) {
        this.unsafe().sendPacket(new PlayerListHeaderFooter(header != null ? ComponentSerializer.toString(header) : EMPTY_TEXT, footer != null ? ComponentSerializer.toString(footer) : EMPTY_TEXT));
    }

    @Override
    public void setTabHeader(BaseComponent[] header, BaseComponent[] footer) {
        this.unsafe().sendPacket(new PlayerListHeaderFooter(header != null ? ComponentSerializer.toString(header) : EMPTY_TEXT, footer != null ? ComponentSerializer.toString(footer) : EMPTY_TEXT));
    }

    @Override
    public void resetTabHeader() {
        this.setTabHeader((BaseComponent)null, null);
    }

    @Override
    public void sendTitle(Title title) {
        title.send(this);
    }

    public String getExtraDataInHandshake() {
        return this.getPendingConnection().getExtraDataInHandshake();
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (!this.ch.isClosing() && this.compressionThreshold == -1 && compressionThreshold >= 0) {
            this.compressionThreshold = compressionThreshold;
            this.unsafe.sendPacket(new SetCompression(compressionThreshold));
            this.ch.setCompressionThreshold(compressionThreshold);
        }
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @ConstructorProperties(value={"bungee", "ch", "name", "pendingConnection"})
    public UserConnection(@NonNull ProxyServer bungee, @NonNull ChannelWrapper ch, @NonNull String name, InitialHandler pendingConnection) {
        if (bungee == null) {
            throw new NullPointerException("bungee");
        }
        if (ch == null) {
            throw new NullPointerException("ch");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public boolean isDimensionChange() {
        return this.dimensionChange;
    }

    public void setDimensionChange(boolean dimensionChange) {
        this.dimensionChange = dimensionChange;
    }

    public Collection<ServerInfo> getPendingConnects() {
        return this.pendingConnects;
    }

    public int getSentPingId() {
        return this.sentPingId;
    }

    public void setSentPingId(int sentPingId) {
        this.sentPingId = sentPingId;
    }

    public long getSentPingTime() {
        return this.sentPingTime;
    }

    public void setSentPingTime(long sentPingTime) {
        this.sentPingTime = sentPingTime;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    @Override
    public ServerInfo getReconnectServer() {
        return this.reconnectServer;
    }

    @Override
    public void setReconnectServer(ServerInfo reconnectServer) {
        this.reconnectServer = reconnectServer;
    }

    public TabList getTabListHandler() {
        return this.tabListHandler;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setServerJoinQueue(Queue<String> serverJoinQueue) {
        this.serverJoinQueue = serverJoinQueue;
    }

    public int getClientEntityId() {
        return this.clientEntityId;
    }

    public void setClientEntityId(int clientEntityId) {
        this.clientEntityId = clientEntityId;
    }

    public int getServerEntityId() {
        return this.serverEntityId;
    }

    public void setServerEntityId(int serverEntityId) {
        this.serverEntityId = serverEntityId;
    }

    public ClientSettings getSettings() {
        return this.settings;
    }

    public Scoreboard getServerSentScoreboard() {
        return this.serverSentScoreboard;
    }

    public Collection<UUID> getSentBossBars() {
        return this.sentBossBars;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public EntityMap getEntityRewrite() {
        return this.entityRewrite;
    }

    public ForgeClientHandler getForgeClientHandler() {
        return this.forgeClientHandler;
    }

    public void setForgeClientHandler(ForgeClientHandler forgeClientHandler) {
        this.forgeClientHandler = forgeClientHandler;
    }

    public ForgeServerHandler getForgeServerHandler() {
        return this.forgeServerHandler;
    }

    public void setForgeServerHandler(ForgeServerHandler forgeServerHandler) {
        this.forgeServerHandler = forgeServerHandler;
    }
}

