/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ThreadLocalRandom;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;

public class RoundRobinInetSocketAddressResolver
extends InetSocketAddressResolver {
    public RoundRobinInetSocketAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor, nameResolver);
    }

    @Override
    protected void doResolve(final InetSocketAddress unresolvedAddress, final Promise<InetSocketAddress> promise) throws Exception {
        this.nameResolver.resolveAll(unresolvedAddress.getHostName()).addListener(new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> inetAddresses = future.getNow();
                    int numAddresses = inetAddresses.size();
                    if (numAddresses == 0) {
                        promise.setFailure(new UnknownHostException(unresolvedAddress.getHostName()));
                    } else {
                        int index = numAddresses == 1 ? 0 : ThreadLocalRandom.current().nextInt(numAddresses);
                        promise.setSuccess(new InetSocketAddress(inetAddresses.get(index), unresolvedAddress.getPort()));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }
}

