/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Title
extends DefinedPacket {
    private Action action;
    private String text;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int index = Title.readVarInt(buf);
        if (protocolVersion <= 210 && index >= 2) {
            ++index;
        }
        this.action = Action.values()[index];
        switch (this.action) {
            case TITLE: 
            case SUBTITLE: 
            case ACTIONBAR: {
                this.text = Title.readString(buf);
                break;
            }
            case TIMES: {
                this.fadeIn = buf.readInt();
                this.stay = buf.readInt();
                this.fadeOut = buf.readInt();
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int index = this.action.ordinal();
        if (protocolVersion <= 210 && index >= 2) {
            --index;
        }
        Title.writeVarInt(index, buf);
        switch (this.action) {
            case TITLE: 
            case SUBTITLE: 
            case ACTIONBAR: {
                Title.writeString(this.text, buf);
                break;
            }
            case TIMES: {
                buf.writeInt(this.fadeIn);
                buf.writeInt(this.stay);
                buf.writeInt(this.fadeOut);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public Action getAction() {
        return this.action;
    }

    public String getText() {
        return this.text;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    public void setStay(int stay) {
        this.stay = stay;
    }

    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    @Override
    public String toString() {
        return "Title(action=" + (Object)((Object)this.getAction()) + ", text=" + this.getText() + ", fadeIn=" + this.getFadeIn() + ", stay=" + this.getStay() + ", fadeOut=" + this.getFadeOut() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Title)) {
            return false;
        }
        Title other = (Title)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        if (this.getFadeIn() != other.getFadeIn()) {
            return false;
        }
        if (this.getStay() != other.getStay()) {
            return false;
        }
        return this.getFadeOut() == other.getFadeOut();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Title;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 0 : ((Object)((Object)$action)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 0 : $text.hashCode());
        result = result * 59 + this.getFadeIn();
        result = result * 59 + this.getStay();
        result = result * 59 + this.getFadeOut();
        return result;
    }

    public static enum Action {
        TITLE,
        SUBTITLE,
        ACTIONBAR,
        TIMES,
        CLEAR,
        RESET;

    }
}

