/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tablist;

import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.TabListHandler;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.packet.PacketC9PlayerListItem;

public class GlobalTabList
implements TabListHandler {
    private final Set<ProxiedPlayer> sentPings = new HashSet<ProxiedPlayer>();

    @Override
    public void onConnect(ProxiedPlayer player) {
        for (UserConnection c : BungeeCord.getInstance().connections.values()) {
            c.packetQueue.add(new PacketC9PlayerListItem(c.displayName, true, c.getPing()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPingChange(ProxiedPlayer player, int ping) {
        Set<ProxiedPlayer> set = this.sentPings;
        synchronized (set) {
            if (!this.sentPings.contains(player)) {
                BungeeCord.getInstance().broadcast(new PacketC9PlayerListItem(player.getDisplayName(), true, player.getPing()));
                this.sentPings.add(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect(ProxiedPlayer player) {
        Set<ProxiedPlayer> set = this.sentPings;
        synchronized (set) {
            BungeeCord.getInstance().broadcast(new PacketC9PlayerListItem(player.getDisplayName(), false, 9999));
            this.sentPings.remove(player);
        }
    }

    @Override
    public void onServerChange(ProxiedPlayer player) {
    }

    @Override
    public boolean onListUpdate(ProxiedPlayer player, String name, boolean online, int ping) {
        return false;
    }
}

