/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityOcelot;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EntitySpider;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public final class SpawnerCreature {
    private static HashMap b = new HashMap();
    protected static final Class[] a = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class};

    protected static ChunkPosition getRandomPosition(World world, int n, int n2) {
        Chunk chunk = world.getChunkAt(n, n2);
        int n3 = n * 16 + world.random.nextInt(16);
        int n4 = n2 * 16 + world.random.nextInt(16);
        int n5 = world.random.nextInt(chunk == null ? world.L() : chunk.h() + 16 - 1);
        return new ChunkPosition(n3, n5, n4);
    }

    public static final int spawnEntities(WorldServer worldServer, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        int n;
        if (!bl && !bl2) {
            return 0;
        }
        b.clear();
        for (n = 0; n < worldServer.players.size(); ++n) {
            object2 = (EntityHuman)worldServer.players.get(n);
            int n2 = MathHelper.floor(((EntityHuman)object2).locX / 16.0);
            int n3 = MathHelper.floor(((EntityHuman)object2).locZ / 16.0);
            int n4 = 8;
            for (int i = -n4; i <= n4; ++i) {
                for (int j = -n4; j <= n4; ++j) {
                    boolean bl3 = i == -n4 || i == n4 || j == -n4 || j == n4;
                    object = new ChunkCoordIntPair(i + n2, j + n3);
                    if (!bl3) {
                        b.put(object, false);
                        continue;
                    }
                    if (b.containsKey(object)) continue;
                    b.put(object, true);
                }
            }
        }
        n = 0;
        object2 = worldServer.getSpawn();
        for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
            if (enumCreatureType.d() && !bl2 || !enumCreatureType.d() && !bl || worldServer.a(enumCreatureType.a()) > enumCreatureType.b() * b.size() / 256) continue;
            block6: for (ChunkCoordIntPair chunkCoordIntPair : b.keySet()) {
                if (((Boolean)b.get(chunkCoordIntPair)).booleanValue()) continue;
                object = SpawnerCreature.getRandomPosition(worldServer, chunkCoordIntPair.x, chunkCoordIntPair.z);
                int n5 = ((ChunkPosition)object).x;
                int n6 = ((ChunkPosition)object).y;
                int n7 = ((ChunkPosition)object).z;
                if (worldServer.s(n5, n6, n7) || worldServer.getMaterial(n5, n6, n7) != enumCreatureType.c()) continue;
                int n8 = 0;
                block7: for (int i = 0; i < 3; ++i) {
                    int n9 = n5;
                    int n10 = n6;
                    int n11 = n7;
                    int n12 = 6;
                    BiomeMeta biomeMeta = null;
                    for (int j = 0; j < 4; ++j) {
                        EntityLiving entityLiving;
                        float f;
                        float f2;
                        float f3;
                        float f4;
                        float f5;
                        float f6;
                        float f7;
                        if (!SpawnerCreature.a(enumCreatureType, (World)worldServer, n9 += worldServer.random.nextInt(n12) - worldServer.random.nextInt(n12), n10 += worldServer.random.nextInt(1) - worldServer.random.nextInt(1), n11 += worldServer.random.nextInt(n12) - worldServer.random.nextInt(n12)) || worldServer.findNearbyPlayer(f7 = (float)n9 + 0.5f, f6 = (float)n10, f5 = (float)n11 + 0.5f, 24.0) != null || (f4 = (f3 = f7 - (float)((ChunkCoordinates)object2).x) * f3 + (f2 = f6 - (float)((ChunkCoordinates)object2).y) * f2 + (f = f5 - (float)((ChunkCoordinates)object2).z) * f) < 576.0f) continue;
                        if (biomeMeta == null && (biomeMeta = worldServer.a(enumCreatureType, n9, n10, n11)) == null) continue block7;
                        try {
                            entityLiving = (EntityLiving)biomeMeta.b.getConstructor(World.class).newInstance(worldServer);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return n;
                        }
                        entityLiving.setPositionRotation(f7, f6, f5, worldServer.random.nextFloat() * 360.0f, 0.0f);
                        if (entityLiving.canSpawn()) {
                            worldServer.addEntity(entityLiving);
                            SpawnerCreature.a(entityLiving, (World)worldServer, f7, f6, f5);
                            if (++n8 >= entityLiving.bl()) continue block6;
                        }
                        n += n8;
                    }
                }
            }
        }
        return n;
    }

    public static boolean a(EnumCreatureType enumCreatureType, World world, int n, int n2, int n3) {
        if (enumCreatureType.c() == Material.WATER) {
            return world.getMaterial(n, n2, n3).isLiquid() && !world.s(n, n2 + 1, n3);
        }
        if (!world.t(n, n2 - 1, n3)) {
            return false;
        }
        int n4 = world.getTypeId(n, n2 - 1, n3);
        return n4 != Block.BEDROCK.id && !world.s(n, n2, n3) && !world.getMaterial(n, n2, n3).isLiquid() && !world.s(n, n2 + 1, n3);
    }

    private static void a(EntityLiving entityLiving, World world, float f, float f2, float f3) {
        if (entityLiving instanceof EntitySpider && world.random.nextInt(100) == 0) {
            EntitySkeleton entitySkeleton = new EntitySkeleton(world);
            entitySkeleton.setPositionRotation(f, f2, f3, entityLiving.yaw, 0.0f);
            world.addEntity(entitySkeleton);
            entitySkeleton.mount(entityLiving);
        } else if (entityLiving instanceof EntitySheep) {
            ((EntitySheep)entityLiving).setColor(EntitySheep.a(world.random));
        } else if (entityLiving instanceof EntityOcelot && world.random.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                EntityOcelot entityOcelot = new EntityOcelot(world);
                entityOcelot.setPositionRotation(f, f2, f3, entityLiving.yaw, 0.0f);
                entityOcelot.setAge(-24000);
                world.addEntity(entityOcelot);
            }
        }
    }

    public static void a(World world, BiomeBase biomeBase, int n, int n2, int n3, int n4, Random random) {
        List list = biomeBase.getMobs(EnumCreatureType.CREATURE);
        if (list.isEmpty()) {
            return;
        }
        while (random.nextFloat() < biomeBase.f()) {
            BiomeMeta biomeMeta = (BiomeMeta)WeightedRandom.a(world.random, list);
            int n5 = biomeMeta.c + random.nextInt(1 + biomeMeta.d - biomeMeta.c);
            int n6 = n + random.nextInt(n3);
            int n7 = n2 + random.nextInt(n4);
            int n8 = n6;
            int n9 = n7;
            for (int i = 0; i < n5; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    int n10 = world.h(n6, n7);
                    if (SpawnerCreature.a(EnumCreatureType.CREATURE, world, n6, n10, n7)) {
                        EntityLiving entityLiving;
                        float f = (float)n6 + 0.5f;
                        float f2 = n10;
                        float f3 = (float)n7 + 0.5f;
                        try {
                            entityLiving = (EntityLiving)biomeMeta.b.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        entityLiving.setPositionRotation(f, f2, f3, random.nextFloat() * 360.0f, 0.0f);
                        world.addEntity(entityLiving);
                        SpawnerCreature.a(entityLiving, world, f, f2, f3);
                        bl = true;
                    }
                    n6 += random.nextInt(5) - random.nextInt(5);
                    n7 += random.nextInt(5) - random.nextInt(5);
                    while (n6 < n || n6 >= n + n3 || n7 < n2 || n7 >= n2 + n3) {
                        n6 = n8 + random.nextInt(5) - random.nextInt(5);
                        n7 = n9 + random.nextInt(5) - random.nextInt(5);
                    }
                }
            }
        }
    }
}

