/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PacketWrapper;

public class HandlerBoss
extends ChannelInboundHandlerAdapter {
    private ChannelWrapper channel;
    private PacketHandler handler;

    public void setHandler(PacketHandler handler) {
        Preconditions.checkArgument(handler != null, "handler");
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel = new ChannelWrapper(ctx);
            this.handler.connected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has connected", this.handler);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.disconnected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has disconnected", this.handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.handler != null) {
            PacketWrapper packet = (PacketWrapper)msg;
            boolean sendPacket = this.handler.shouldHandle(packet);
            try {
                if (sendPacket && packet.packet != null) {
                    try {
                        packet.packet.handle(this.handler);
                    }
                    catch (CancelSendSignal ex) {
                        sendPacket = false;
                    }
                }
                if (sendPacket) {
                    this.handler.handle(packet);
                }
            }
            finally {
                packet.trySingleRelease();
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            if (cause instanceof ReadTimeoutException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - read timed out", this.handler);
            } else if (cause instanceof DecoderException && cause.getCause() instanceof BadPacketException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - bad packet ID, are mods in use!? {1}", new Object[]{this.handler, cause.getCause().getMessage()});
            } else if (cause instanceof DecoderException && cause.getCause() instanceof OverflowPacketException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - overflow in packet detected! {1}", new Object[]{this.handler, cause.getCause().getMessage()});
            } else if (cause instanceof IOException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - IOException: {1}", new Object[]{this.handler, cause.getMessage()});
            } else {
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - encountered exception", cause);
            }
            if (this.handler != null) {
                try {
                    this.handler.exception(cause);
                }
                catch (Exception ex) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - exception processing exception", ex);
                }
            }
            ctx.close();
        }
    }
}

