/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(0, Handshake.class);
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(0, 31, KeepAlive.class);
            this.TO_CLIENT.registerPacket(1, 35, Login.class);
            this.TO_CLIENT.registerPacket(2, 15, Chat.class);
            this.TO_CLIENT.registerPacket(7, 51, Respawn.class);
            this.TO_CLIENT.registerPacket(12, 12, BossBar.class, true);
            this.TO_CLIENT.registerPacket(56, 45, PlayerListItem.class);
            this.TO_CLIENT.registerPacket(58, 14, TabCompleteResponse.class);
            this.TO_CLIENT.registerPacket(59, 63, ScoreboardObjective.class);
            this.TO_CLIENT.registerPacket(60, 66, ScoreboardScore.class);
            this.TO_CLIENT.registerPacket(61, 56, ScoreboardDisplay.class);
            this.TO_CLIENT.registerPacket(62, 65, Team.class);
            this.TO_CLIENT.registerPacket(63, 24, PluginMessage.class);
            this.TO_CLIENT.registerPacket(64, 26, Kick.class);
            this.TO_CLIENT.registerPacket(69, 69, Title.class);
            this.TO_CLIENT.registerPacket(71, 72, PlayerListHeaderFooter.class);
            this.TO_SERVER.registerPacket(0, 11, KeepAlive.class);
            this.TO_SERVER.registerPacket(1, 2, Chat.class);
            this.TO_SERVER.registerPacket(20, 1, TabCompleteRequest.class);
            this.TO_SERVER.registerPacket(21, 4, ClientSettings.class);
            this.TO_SERVER.registerPacket(23, 9, PluginMessage.class);
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(0, StatusResponse.class);
            this.TO_CLIENT.registerPacket(1, PingPacket.class);
            this.TO_SERVER.registerPacket(0, StatusRequest.class);
            this.TO_SERVER.registerPacket(1, PingPacket.class);
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(0, Kick.class);
            this.TO_CLIENT.registerPacket(1, EncryptionRequest.class);
            this.TO_CLIENT.registerPacket(2, LoginSuccess.class);
            this.TO_CLIENT.registerPacket(3, SetCompression.class);
            this.TO_SERVER.registerPacket(0, LoginRequest.class);
            this.TO_SERVER.registerPacket(1, EncryptionResponse.class);
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public static List<Integer> supportedVersions;
    public final DirectionData TO_SERVER = new DirectionData(ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(ProtocolConstants.Direction.TO_CLIENT);

    static {
        supportedVersions = Arrays.asList(47, 107, 108);
    }

    public class DirectionData {
        private final ProtocolConstants.Direction direction;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap<Class<? extends DefinedPacket>>(255);
        private final Class<? extends DefinedPacket>[] packetClasses = new Class[255];
        private final Constructor<? extends DefinedPacket>[] packetConstructors = new Constructor[255];
        private final TIntObjectMap<TIntIntMap> packetRemap = new TIntObjectHashMap<TIntIntMap>();
        private final TIntObjectMap<TIntIntMap> packetRemapInv = new TIntObjectHashMap<TIntIntMap>();

        public final DefinedPacket createPacket(int id, int protocol) {
            TIntIntMap remap = this.packetRemap.get(protocol);
            if (remap != null) {
                if (!remap.containsKey(id)) {
                    return null;
                }
                id = remap.get(id);
            }
            if (id > 255) {
                throw new BadPacketException("Packet with id " + id + " outside of range ");
            }
            Constructor<? extends DefinedPacket> constructor = this.packetConstructors[id];
            try {
                return constructor == null ? null : constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new BadPacketException("Could not construct packet with id " + id, ex);
            }
        }

        protected final void registerPacket(int id, Class<? extends DefinedPacket> packetClass) {
            this.registerPacket(id, id, packetClass);
        }

        protected final void registerPacket(int id, int newId, Class<? extends DefinedPacket> packetClass) {
            this.registerPacket(id, newId, packetClass, false);
        }

        protected final void registerPacket(int id, int newId, Class<? extends DefinedPacket> packetClass, boolean newOnly) {
            try {
                this.packetConstructors[id] = packetClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new BadPacketException("No NoArgsConstructor for packet class " + packetClass);
            }
            this.packetClasses[id] = packetClass;
            this.packetMap.put(packetClass, id);
            if (!newOnly) {
                this.packetRemap.get(47).put(id, id);
                this.packetRemapInv.get(47).put(id, id);
            }
            this.packetRemap.get(107).put(newId, id);
            this.packetRemapInv.get(107).put(id, newId);
        }

        protected final void unregisterPacket(int id) {
            this.packetMap.remove(this.packetClasses[id]);
            this.packetClasses[id] = null;
            this.packetConstructors[id] = null;
        }

        final int getId(Class<? extends DefinedPacket> packet, int protocol) {
            Preconditions.checkArgument(this.packetMap.containsKey(packet), "Cannot get ID for packet " + packet);
            int id = this.packetMap.get(packet);
            TIntIntMap remap = this.packetRemapInv.get(protocol);
            if (remap != null) {
                return remap.get(id);
            }
            return id;
        }

        @ConstructorProperties(value={"direction"})
        public DirectionData(ProtocolConstants.Direction direction) {
            this.packetRemap.put(47, new TIntIntHashMap());
            this.packetRemapInv.put(47, new TIntIntHashMap());
            this.packetRemap.put(107, new TIntIntHashMap());
            this.packetRemapInv.put(107, new TIntIntHashMap());
            this.packetRemap.put(108, this.packetRemap.get(107));
            this.packetRemapInv.put(108, this.packetRemapInv.get(107));
            this.direction = direction;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }
}

