/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EncryptionResponse
extends DefinedPacket {
    private byte[] sharedSecret;
    private byte[] verifyToken;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.sharedSecret = EncryptionResponse.readArray(buf, 256);
        this.verifyToken = EncryptionResponse.readArray(buf, 256);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        EncryptionResponse.writeArray(this.sharedSecret, buf);
        EncryptionResponse.writeArray(this.verifyToken, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public void setSharedSecret(byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    @Override
    public String toString() {
        return "EncryptionResponse(sharedSecret=" + Arrays.toString(this.getSharedSecret()) + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    public EncryptionResponse() {
    }

    @ConstructorProperties(value={"sharedSecret", "verifyToken"})
    public EncryptionResponse(byte[] sharedSecret, byte[] verifyToken) {
        this.sharedSecret = sharedSecret;
        this.verifyToken = verifyToken;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionResponse)) {
            return false;
        }
        EncryptionResponse other = (EncryptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSharedSecret(), other.getSharedSecret())) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptionResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSharedSecret());
        result = result * 59 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }
}

