/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import java.util.Collection;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.tab.TabList;

public class Global
extends TabList {
    private boolean sentPing;

    public Global(ProxiedPlayer player) {
        super(player);
    }

    @Override
    public void onUpdate(PlayerListItem playerListItem) {
    }

    @Override
    public void onPingChange(int ping) {
        if (!this.sentPing) {
            this.sentPing = true;
            PlayerListItem packet = new PlayerListItem();
            packet.setAction(PlayerListItem.Action.UPDATE_LATENCY);
            PlayerListItem.Item item = new PlayerListItem.Item();
            item.setUuid(this.player.getUniqueId());
            item.setUsername(this.player.getName());
            item.setDisplayName(ComponentSerializer.toString(TextComponent.fromLegacyText(this.player.getDisplayName())));
            item.setPing(this.player.getPing());
            packet.setItems(new PlayerListItem.Item[]{item});
            BungeeCord.getInstance().broadcast(packet);
        }
    }

    @Override
    public void onServerChange() {
    }

    @Override
    public void onConnect() {
        PlayerListItem playerListItem = new PlayerListItem();
        playerListItem.setAction(PlayerListItem.Action.ADD_PLAYER);
        Collection<ProxiedPlayer> players = BungeeCord.getInstance().getPlayers();
        PlayerListItem.Item[] items = new PlayerListItem.Item[players.size()];
        playerListItem.setItems(items);
        int i = 0;
        for (ProxiedPlayer p : players) {
            int n = i++;
            PlayerListItem.Item item = new PlayerListItem.Item();
            items[n] = item;
            PlayerListItem.Item item2 = item;
            item2.setUuid(p.getUniqueId());
            item2.setUsername(p.getName());
            item2.setDisplayName(ComponentSerializer.toString(TextComponent.fromLegacyText(p.getDisplayName())));
            LoginResult loginResult = ((UserConnection)p).getPendingConnection().getLoginProfile();
            if (loginResult != null) {
                String[][] props = new String[loginResult.getProperties().length][];
                for (int j = 0; j < props.length; ++j) {
                    props[j] = new String[]{loginResult.getProperties()[j].getName(), loginResult.getProperties()[j].getValue(), loginResult.getProperties()[j].getSignature()};
                }
                item2.setProperties(props);
            } else {
                item2.setProperties(new String[0][0]);
            }
            item2.setGamemode(((UserConnection)p).getGamemode());
            item2.setPing(p.getPing());
        }
        if (this.player.getPendingConnection().getVersion() >= 47) {
            this.player.unsafe().sendPacket(playerListItem);
        } else {
            for (PlayerListItem.Item item : playerListItem.getItems()) {
                PlayerListItem packet = new PlayerListItem();
                packet.setAction(playerListItem.getAction());
                packet.setItems(new PlayerListItem.Item[]{item});
                this.player.unsafe().sendPacket(packet);
            }
        }
        PlayerListItem packet = new PlayerListItem();
        packet.setAction(PlayerListItem.Action.ADD_PLAYER);
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUuid(this.player.getUniqueId());
        item.setUsername(this.player.getName());
        item.setDisplayName(ComponentSerializer.toString(TextComponent.fromLegacyText(this.player.getDisplayName())));
        LoginResult loginResult = ((UserConnection)this.player).getPendingConnection().getLoginProfile();
        if (loginResult != null) {
            String[][] props = new String[loginResult.getProperties().length][];
            for (int j = 0; j < props.length; ++j) {
                props[j] = new String[]{loginResult.getProperties()[j].getName(), loginResult.getProperties()[j].getValue(), loginResult.getProperties()[j].getSignature()};
            }
            item.setProperties(props);
        } else {
            item.setProperties(new String[0][0]);
        }
        item.setGamemode(((UserConnection)this.player).getGamemode());
        item.setPing(this.player.getPing());
        packet.setItems(new PlayerListItem.Item[]{item});
        BungeeCord.getInstance().broadcast(packet);
    }

    @Override
    public void onDisconnect() {
        PlayerListItem packet = new PlayerListItem();
        packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUuid(this.player.getUniqueId());
        item.setUsername(this.player.getName());
        packet.setItems(new PlayerListItem.Item[]{item});
        BungeeCord.getInstance().broadcast(packet);
    }
}

