/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.tab.TabList;

public class ServerUnique
extends TabList {
    private final Collection<UUID> uuids = new HashSet<UUID>();
    private final Collection<String> usernames = new HashSet<String>();

    public ServerUnique(ProxiedPlayer player) {
        super(player);
    }

    @Override
    public void onUpdate(PlayerListItem playerListItem) {
        for (PlayerListItem.Item item : playerListItem.getItems()) {
            if (playerListItem.getAction() == PlayerListItem.Action.ADD_PLAYER) {
                if (item.getUuid() != null) {
                    this.uuids.add(item.getUuid());
                    continue;
                }
                this.usernames.add(item.getUsername());
                continue;
            }
            if (playerListItem.getAction() != PlayerListItem.Action.REMOVE_PLAYER) continue;
            if (item.getUuid() != null) {
                this.uuids.remove(item.getUuid());
                continue;
            }
            this.usernames.remove(item.getUsername());
        }
        this.player.unsafe().sendPacket(playerListItem);
    }

    @Override
    public void onPingChange(int ping) {
    }

    @Override
    public void onServerChange() {
        PlayerListItem.Item item;
        PlayerListItem packet = new PlayerListItem();
        packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
        PlayerListItem.Item[] items = new PlayerListItem.Item[this.uuids.size() + this.usernames.size()];
        int i = 0;
        for (UUID uuid : this.uuids) {
            int n = i++;
            PlayerListItem.Item item2 = new PlayerListItem.Item();
            items[n] = item2;
            item = item2;
            item.setUuid(uuid);
        }
        for (String username : this.usernames) {
            int n = i++;
            PlayerListItem.Item item3 = new PlayerListItem.Item();
            items[n] = item3;
            item = item3;
            item.setUsername(username);
            item.setDisplayName(username);
        }
        packet.setItems(items);
        if (this.player.getPendingConnection().getVersion() >= 47) {
            this.player.unsafe().sendPacket(packet);
        } else {
            for (PlayerListItem.Item item4 : packet.getItems()) {
                PlayerListItem p2 = new PlayerListItem();
                p2.setAction(packet.getAction());
                p2.setItems(new PlayerListItem.Item[]{item4});
                this.player.unsafe().sendPacket(p2);
            }
        }
        this.uuids.clear();
        this.usernames.clear();
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }
}

