/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.ChannelException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;

final class Native {
    public static final int EPOLLIN = 1;
    public static final int EPOLLOUT = 2;
    public static final int EPOLLACCEPT = 4;
    public static final int EPOLLRDHUP = 8;
    public static final int IOV_MAX;
    public static final int UIO_MAX_IOV;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    private static final byte[] IPV4_MAPPED_IPV6_PREFIX;
    private static final int ERRNO_EBADF_NEGATIVE;
    private static final int ERRNO_EPIPE_NEGATIVE;
    private static final int ERRNO_EAGAIN_NEGATIVE;
    private static final int ERRNO_EWOULDBLOCK_NEGATIVE;
    private static final int ERRNO_EINPROGRESS_NEGATIVE;
    private static final String[] ERRORS;
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION;
    private static final IOException CONNECTION_RESET_EXCEPTION_WRITE;
    private static final IOException CONNECTION_RESET_EXCEPTION_WRITEV;
    private static final IOException CONNECTION_RESET_EXCEPTION_READ;
    private static final IOException CONNECTION_RESET_EXCEPTION_SENDFILE;
    private static final IOException CONNECTION_RESET_EXCEPTION_SENDTO;
    private static final IOException CONNECTION_RESET_EXCEPTION_SENDMSG;
    private static final IOException CONNECTION_RESET_EXCEPTION_SENDMMSG;

    private static IOException newConnectionResetException(String method) {
        IOException exception = Native.newIOException(method, ERRNO_EPIPE_NEGATIVE);
        exception.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return exception;
    }

    private static IOException newIOException(String method, int err) {
        return new IOException(method + "() failed: " + ERRORS[-err]);
    }

    private static int ioResult(String method, int err, IOException resetCause) throws IOException {
        if (err == ERRNO_EAGAIN_NEGATIVE || err == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (err == ERRNO_EPIPE_NEGATIVE) {
            throw resetCause;
        }
        if (err == ERRNO_EBADF_NEGATIVE) {
            throw CLOSED_CHANNEL_EXCEPTION;
        }
        throw Native.newIOException(method, err);
    }

    public static native int eventFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    public static native int epollCreate();

    public static native int epollWait(int var0, long[] var1, int var2);

    public static native void epollCtlAdd(int var0, int var1, int var2, int var3);

    public static native void epollCtlMod(int var0, int var1, int var2, int var3);

    public static native void epollCtlDel(int var0, int var1);

    private static native int errnoEBADF();

    private static native int errnoEPIPE();

    private static native int errnoEAGAIN();

    private static native int errnoEWOULDBLOCK();

    private static native int errnoEINPROGRESS();

    private static native String strError(int var0);

    public static void close(int fd) throws IOException {
        int res = Native.close0(fd);
        if (res < 0) {
            throw Native.newIOException("close", res);
        }
    }

    private static native int close0(int var0);

    public static int write(int fd, ByteBuffer buf, int pos, int limit) throws IOException {
        int res = Native.write0(fd, buf, pos, limit);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("write", res, CONNECTION_RESET_EXCEPTION_WRITE);
    }

    private static native int write0(int var0, ByteBuffer var1, int var2, int var3);

    public static int writeAddress(int fd, long address, int pos, int limit) throws IOException {
        int res = Native.writeAddress0(fd, address, pos, limit);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("writeAddress", res, CONNECTION_RESET_EXCEPTION_WRITE);
    }

    private static native int writeAddress0(int var0, long var1, int var3, int var4);

    public static long writev(int fd, ByteBuffer[] buffers, int offset, int length) throws IOException {
        long res = Native.writev0(fd, buffers, offset, length);
        if (res >= 0L) {
            return res;
        }
        return Native.ioResult("writev", (int)res, CONNECTION_RESET_EXCEPTION_WRITEV);
    }

    private static native long writev0(int var0, ByteBuffer[] var1, int var2, int var3);

    public static long writevAddresses(int fd, long memoryAddress, int length) throws IOException {
        long res = Native.writevAddresses0(fd, memoryAddress, length);
        if (res >= 0L) {
            return res;
        }
        return Native.ioResult("writevAddresses", (int)res, CONNECTION_RESET_EXCEPTION_WRITEV);
    }

    private static native long writevAddresses0(int var0, long var1, int var3);

    public static int read(int fd, ByteBuffer buf, int pos, int limit) throws IOException {
        int res = Native.read0(fd, buf, pos, limit);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Native.ioResult("read", res, CONNECTION_RESET_EXCEPTION_READ);
    }

    private static native int read0(int var0, ByteBuffer var1, int var2, int var3);

    public static int readAddress(int fd, long address, int pos, int limit) throws IOException {
        int res = Native.readAddress0(fd, address, pos, limit);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        return Native.ioResult("readAddress", res, CONNECTION_RESET_EXCEPTION_READ);
    }

    private static native int readAddress0(int var0, long var1, int var3, int var4);

    public static long sendfile(int dest, DefaultFileRegion src, long baseOffset, long offset, long length) throws IOException {
        src.open();
        long res = Native.sendfile0(dest, src, baseOffset, offset, length);
        if (res >= 0L) {
            return res;
        }
        return Native.ioResult("sendfile", (int)res, CONNECTION_RESET_EXCEPTION_SENDFILE);
    }

    private static native long sendfile0(int var0, DefaultFileRegion var1, long var2, long var4, long var6) throws IOException;

    public static int sendTo(int fd, ByteBuffer buf, int pos, int limit, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = Native.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Native.sendTo0(fd, buf, pos, limit, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("sendTo", res, CONNECTION_RESET_EXCEPTION_SENDTO);
    }

    private static native int sendTo0(int var0, ByteBuffer var1, int var2, int var3, byte[] var4, int var5, int var6);

    public static int sendToAddress(int fd, long memoryAddress, int pos, int limit, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = Native.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Native.sendToAddress0(fd, memoryAddress, pos, limit, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("sendToAddress", res, CONNECTION_RESET_EXCEPTION_SENDTO);
    }

    private static native int sendToAddress0(int var0, long var1, int var3, int var4, byte[] var5, int var6, int var7);

    public static int sendToAddresses(int fd, long memoryAddress, int length, InetAddress addr, int port) throws IOException {
        int scopeId;
        byte[] address;
        if (addr instanceof Inet6Address) {
            address = addr.getAddress();
            scopeId = ((Inet6Address)addr).getScopeId();
        } else {
            scopeId = 0;
            address = Native.ipv4MappedIpv6Address(addr.getAddress());
        }
        int res = Native.sendToAddresses(fd, memoryAddress, length, address, scopeId, port);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("sendToAddresses", res, CONNECTION_RESET_EXCEPTION_SENDMSG);
    }

    private static native int sendToAddresses(int var0, long var1, int var3, byte[] var4, int var5, int var6);

    public static native EpollDatagramChannel.DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    public static native EpollDatagramChannel.DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4) throws IOException;

    public static int sendmmsg(int fd, NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        int res = Native.sendmmsg0(fd, msgs, offset, len);
        if (res >= 0) {
            return res;
        }
        return Native.ioResult("sendmmsg", res, CONNECTION_RESET_EXCEPTION_SENDMMSG);
    }

    private static native int sendmmsg0(int var0, NativeDatagramPacketArray.NativeDatagramPacket[] var1, int var2, int var3);

    private static native boolean isSupportingSendmmsg();

    public static int socketStreamFd() {
        int res = Native.socketStream();
        if (res < 0) {
            throw new ChannelException(Native.newIOException("socketStreamFd", res));
        }
        return res;
    }

    public static int socketDgramFd() {
        int res = Native.socketDgram();
        if (res < 0) {
            throw new ChannelException(Native.newIOException("socketDgramFd", res));
        }
        return res;
    }

    private static native int socketStream();

    private static native int socketDgram();

    public static void bind(int fd, InetAddress addr, int port) throws IOException {
        NativeInetAddress address = Native.toNativeInetAddress(addr);
        int res = Native.bind(fd, address.address, address.scopeId, port);
        if (res < 0) {
            throw Native.newIOException("bind", res);
        }
    }

    private static native int bind(int var0, byte[] var1, int var2, int var3);

    public static void listen(int fd, int backlog) throws IOException {
        int res = Native.listen0(fd, backlog);
        if (res < 0) {
            throw Native.newIOException("listen", res);
        }
    }

    private static native int listen0(int var0, int var1);

    public static boolean connect(int fd, InetAddress addr, int port) throws IOException {
        NativeInetAddress address = Native.toNativeInetAddress(addr);
        int res = Native.connect(fd, address.address, address.scopeId, port);
        if (res < 0) {
            if (res == ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            throw Native.newIOException("connect", res);
        }
        return true;
    }

    private static native int connect(int var0, byte[] var1, int var2, int var3);

    public static boolean finishConnect(int fd) throws IOException {
        int res = Native.finishConnect0(fd);
        if (res < 0) {
            if (res == ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            throw Native.newIOException("finishConnect", res);
        }
        return true;
    }

    private static native int finishConnect0(int var0);

    public static InetSocketAddress remoteAddress(int fd) {
        byte[] addr = Native.remoteAddress0(fd);
        return Native.address(addr);
    }

    public static InetSocketAddress localAddress(int fd) {
        byte[] addr = Native.localAddress0(fd);
        return Native.address(addr);
    }

    static InetSocketAddress address(byte[] addr) {
        int len = addr.length;
        int port = Native.decodeInt(addr, len - 4);
        try {
            InetAddress address;
            switch (len) {
                case 8: {
                    byte[] ipv4 = new byte[4];
                    System.arraycopy(addr, 0, ipv4, 0, 4);
                    address = InetAddress.getByAddress(ipv4);
                    break;
                }
                case 24: {
                    byte[] ipv6 = new byte[16];
                    System.arraycopy(addr, 0, ipv6, 0, 16);
                    int scopeId = Native.decodeInt(addr, len - 8);
                    address = Inet6Address.getByAddress(null, ipv6, scopeId);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e) {
            throw new Error("Should never happen", e);
        }
    }

    private static int decodeInt(byte[] addr, int index) {
        return (addr[index] & 0xFF) << 24 | (addr[index + 1] & 0xFF) << 16 | (addr[index + 2] & 0xFF) << 8 | addr[index + 3] & 0xFF;
    }

    private static native byte[] remoteAddress0(int var0);

    private static native byte[] localAddress0(int var0);

    public static int accept(int fd) throws IOException {
        int res = Native.accept0(fd);
        if (res >= 0) {
            return res;
        }
        if (res == ERRNO_EAGAIN_NEGATIVE || res == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Native.newIOException("accept", res);
    }

    private static native int accept0(int var0);

    public static void shutdown(int fd, boolean read, boolean write) throws IOException {
        int res = Native.shutdown0(fd, read, write);
        if (res < 0) {
            throw Native.newIOException("shutdown", res);
        }
    }

    private static native int shutdown0(int var0, boolean var1, boolean var2);

    public static native int getReceiveBufferSize(int var0);

    public static native int getSendBufferSize(int var0);

    public static native int isKeepAlive(int var0);

    public static native int isReuseAddress(int var0);

    public static native int isReusePort(int var0);

    public static native int isTcpNoDelay(int var0);

    public static native int isTcpCork(int var0);

    public static native int getSoLinger(int var0);

    public static native int getTrafficClass(int var0);

    public static native int isBroadcast(int var0);

    public static native int getTcpKeepIdle(int var0);

    public static native int getTcpKeepIntvl(int var0);

    public static native int getTcpKeepCnt(int var0);

    public static native void setKeepAlive(int var0, int var1);

    public static native void setReceiveBufferSize(int var0, int var1);

    public static native void setReuseAddress(int var0, int var1);

    public static native void setReusePort(int var0, int var1);

    public static native void setSendBufferSize(int var0, int var1);

    public static native void setTcpNoDelay(int var0, int var1);

    public static native void setTcpCork(int var0, int var1);

    public static native void setSoLinger(int var0, int var1);

    public static native void setTrafficClass(int var0, int var1);

    public static native void setBroadcast(int var0, int var1);

    public static native void setTcpKeepIdle(int var0, int var1);

    public static native void setTcpKeepIntvl(int var0, int var1);

    public static native void setTcpKeepCnt(int var0, int var1);

    private static NativeInetAddress toNativeInetAddress(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        if (addr instanceof Inet6Address) {
            return new NativeInetAddress(bytes, ((Inet6Address)addr).getScopeId());
        }
        return new NativeInetAddress(Native.ipv4MappedIpv6Address(bytes));
    }

    static byte[] ipv4MappedIpv6Address(byte[] ipv4) {
        byte[] address = new byte[16];
        System.arraycopy(IPV4_MAPPED_IPV6_PREFIX, 0, address, 0, IPV4_MAPPED_IPV6_PREFIX.length);
        System.arraycopy(ipv4, 0, address, 12, ipv4.length);
        return address;
    }

    public static native String kernelVersion();

    private static native int iovMax();

    private static native int uioMaxIov();

    private Native() {
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.UK).trim();
        if (!name.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        NativeLibraryLoader.load("netty-transport-native-epoll", PlatformDependent.getClassLoader(Native.class));
        IOV_MAX = Native.iovMax();
        UIO_MAX_IOV = Native.uioMaxIov();
        IS_SUPPORTING_SENDMMSG = Native.isSupportingSendmmsg();
        IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
        ERRNO_EBADF_NEGATIVE = -Native.errnoEBADF();
        ERRNO_EPIPE_NEGATIVE = -Native.errnoEPIPE();
        ERRNO_EAGAIN_NEGATIVE = -Native.errnoEAGAIN();
        ERRNO_EWOULDBLOCK_NEGATIVE = -Native.errnoEWOULDBLOCK();
        ERRNO_EINPROGRESS_NEGATIVE = -Native.errnoEINPROGRESS();
        ERRORS = new String[1024];
        for (int i = 0; i < ERRORS.length; ++i) {
            Native.ERRORS[i] = Native.strError(i);
        }
        CONNECTION_RESET_EXCEPTION_WRITE = Native.newConnectionResetException("write");
        CONNECTION_RESET_EXCEPTION_WRITEV = Native.newConnectionResetException("writev");
        CONNECTION_RESET_EXCEPTION_READ = Native.newConnectionResetException("read");
        CONNECTION_RESET_EXCEPTION_SENDFILE = Native.newConnectionResetException("sendfile");
        CONNECTION_RESET_EXCEPTION_SENDTO = Native.newConnectionResetException("sendto");
        CONNECTION_RESET_EXCEPTION_SENDMSG = Native.newConnectionResetException("sendmsg");
        CONNECTION_RESET_EXCEPTION_SENDMMSG = Native.newConnectionResetException("sendmmsg");
        CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    private static class NativeInetAddress {
        final byte[] address;
        final int scopeId;

        NativeInetAddress(byte[] address, int scopeId) {
            this.address = address;
            this.scopeId = scopeId;
        }

        NativeInetAddress(byte[] address) {
            this(address, 0);
        }
    }
}

