/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ServerConnection
implements Server {
    private final ChannelWrapper ch;
    private final BungeeServerInfo info;
    private boolean isObsolete;
    private final boolean forgeServer = false;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            ServerConnection.this.ch.write(packet);
        }
    };

    @Override
    public void sendData(String channel, byte[] data) {
        this.unsafe().sendPacket(new PluginMessage(channel, data, false));
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(TextComponent.fromLegacyText(reason));
    }

    @Override
    public synchronized void disconnect(BaseComponent ... reason) {
        if (!this.ch.isClosed()) {
            this.unsafe().sendPacket(new Kick(ComponentSerializer.toString(reason)));
            this.ch.getHandle().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ServerConnection.this.ch.getHandle().close();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect(new BaseComponent[]{reason});
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @ConstructorProperties(value={"ch", "info"})
    public ServerConnection(ChannelWrapper ch, BungeeServerInfo info) {
        this.ch = ch;
        this.info = info;
    }

    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    public BungeeServerInfo getInfo() {
        return this.info;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public boolean isForgeServer() {
        return this.forgeServer;
    }
}

