/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import net.md_5.bungee.BungeeCipher;

public class FallbackCipher
implements BungeeCipher {
    private final Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
    private static final ThreadLocal<byte[]> heapInLocal = new EmptyByteThreadLocal();
    private static final ThreadLocal<byte[]> heapOutLocal = new EmptyByteThreadLocal();

    @Override
    public void init(boolean forEncryption, SecretKey key) throws GeneralSecurityException {
        int mode = forEncryption ? 1 : 2;
        this.cipher.init(mode, (Key)key, new IvParameterSpec(key.getEncoded()));
    }

    @Override
    public void cipher(ByteBuf in, ByteBuf out) throws ShortBufferException {
        int outputSize;
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        byte[] heapOut = heapOutLocal.get();
        if (heapOut.length < (outputSize = this.cipher.getOutputSize(readableBytes))) {
            heapOut = new byte[outputSize];
            heapOutLocal.set(heapOut);
        }
        out.writeBytes(heapOut, 0, this.cipher.update(heapIn, 0, readableBytes, heapOut));
    }

    @Override
    public ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws ShortBufferException {
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        ByteBuf heapOut = ctx.alloc().heapBuffer(this.cipher.getOutputSize(readableBytes));
        heapOut.writerIndex(this.cipher.update(heapIn, 0, readableBytes, heapOut.array(), heapOut.arrayOffset()));
        return heapOut;
    }

    @Override
    public void free() {
    }

    private byte[] bufToByte(ByteBuf in) {
        int readableBytes;
        byte[] heapIn = heapInLocal.get();
        if (heapIn.length < (readableBytes = in.readableBytes())) {
            heapIn = new byte[readableBytes];
            heapInLocal.set(heapIn);
        }
        in.readBytes(heapIn, 0, readableBytes);
        return heapIn;
    }

    private static class EmptyByteThreadLocal
    extends ThreadLocal<byte[]> {
        private EmptyByteThreadLocal() {
        }

        @Override
        protected byte[] initialValue() {
            return new byte[0];
        }
    }
}

