/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import net.md_5.bungee.entitymap.EntityMap_14_21_b;
import net.md_5.bungee.entitymap.EntityMap_1_7_2;
import net.md_5.bungee.entitymap.EntityMap_1_7_6;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public abstract class EntityMap {
    private final boolean[] clientboundInts = new boolean[256];
    private final boolean[] clientboundVarInts = new boolean[256];
    private final boolean[] serverboundInts = new boolean[256];
    private final boolean[] serverboundVarInts = new boolean[256];

    EntityMap() {
    }

    public static EntityMap getEntityMap(int version) {
        switch (version) {
            case 4: {
                return new EntityMap_1_7_2();
            }
            case 5: {
                return new EntityMap_1_7_6();
            }
            case 47: {
                return new EntityMap_14_21_b();
            }
        }
        throw new RuntimeException("Version " + version + " has no entity map");
    }

    protected void addRewrite(int id, ProtocolConstants.Direction direction, boolean varint) {
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            if (varint) {
                this.clientboundVarInts[id] = true;
            } else {
                this.clientboundInts[id] = true;
            }
        } else if (varint) {
            this.serverboundVarInts[id] = true;
        } else {
            this.serverboundInts[id] = true;
        }
    }

    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.serverboundInts, this.serverboundVarInts);
    }

    public void rewriteClientbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.clientboundInts, this.clientboundVarInts);
    }

    protected static void rewriteInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = packet.getInt(offset);
        if (readId == oldId) {
            packet.setInt(offset, newId);
        } else if (readId == newId) {
            packet.setInt(offset, oldId);
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    protected static void rewriteVarInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = DefinedPacket.readVarInt(packet);
        int readIdLength = packet.readerIndex() - offset;
        if (readId == oldId || readId == newId) {
            ByteBuf data = packet.slice().copy();
            packet.readerIndex(offset);
            packet.writerIndex(offset);
            DefinedPacket.writeVarInt(readId == oldId ? newId : oldId, packet);
            packet.writeBytes(data);
            data.release();
        }
    }

    private static void rewrite(ByteBuf packet, int oldId, int newId, boolean[] ints, boolean[] varints) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (ints[packetId]) {
            EntityMap.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength);
        } else if (varints[packetId]) {
            EntityMap.rewriteVarInt(packet, oldId, newId, readerIndex + packetIdLength);
        }
        packet.readerIndex(readerIndex);
    }
}

