/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteRequest
extends DefinedPacket {
    private String cursor;
    private boolean hasPositon;
    private long position;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.cursor = TabCompleteRequest.readString(buf);
        if (protocolVersion >= 47 && (this.hasPositon = buf.readBoolean())) {
            this.position = buf.readLong();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        TabCompleteRequest.writeString(this.cursor, buf);
        if (protocolVersion >= 47) {
            buf.writeBoolean(this.hasPositon);
            if (this.hasPositon) {
                buf.writeLong(this.position);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean isHasPositon() {
        return this.hasPositon;
    }

    public long getPosition() {
        return this.position;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public void setHasPositon(boolean hasPositon) {
        this.hasPositon = hasPositon;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    @Override
    public String toString() {
        return "TabCompleteRequest(cursor=" + this.getCursor() + ", hasPositon=" + this.isHasPositon() + ", position=" + this.getPosition() + ")";
    }

    public TabCompleteRequest() {
    }

    @ConstructorProperties(value={"cursor", "hasPositon", "position"})
    public TabCompleteRequest(String cursor, boolean hasPositon, long position) {
        this.cursor = cursor;
        this.hasPositon = hasPositon;
        this.position = position;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabCompleteRequest)) {
            return false;
        }
        TabCompleteRequest other = (TabCompleteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        if (this.isHasPositon() != other.isHasPositon()) {
            return false;
        }
        return this.getPosition() == other.getPosition();
    }

    public boolean canEqual(Object other) {
        return other instanceof TabCompleteRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 0 : $cursor.hashCode());
        result = result * 59 + (this.isHasPositon() ? 79 : 97);
        long $position = this.getPosition();
        result = result * 59 + (int)($position >>> 32 ^ $position);
        return result;
    }
}

