/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityFireball
extends Entity {
    private int e = -1;
    private int f = -1;
    private int g = -1;
    private int h = 0;
    private boolean i = false;
    public EntityLiving shooter;
    private int j;
    private int an = 0;
    public double dirX;
    public double dirY;
    public double dirZ;

    public EntityFireball(World world) {
        super(world);
        this.a(1.0f, 1.0f);
    }

    protected void a() {
    }

    public EntityFireball(World world, double d, double d2, double d3, double d4, double d5, double d6) {
        super(world);
        this.a(1.0f, 1.0f);
        this.setPositionRotation(d, d2, d3, this.yaw, this.pitch);
        this.setPosition(d, d2, d3);
        double d7 = MathHelper.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        this.dirX = d4 / d7 * 0.1;
        this.dirY = d5 / d7 * 0.1;
        this.dirZ = d6 / d7 * 0.1;
    }

    public EntityFireball(World world, EntityLiving entityLiving, double d, double d2, double d3) {
        super(world);
        this.shooter = entityLiving;
        this.a(1.0f, 1.0f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY, entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motZ = 0.0;
        this.motY = 0.0;
        this.motX = 0.0;
        double d4 = MathHelper.sqrt((d += this.random.nextGaussian() * 0.4) * d + (d2 += this.random.nextGaussian() * 0.4) * d2 + (d3 += this.random.nextGaussian() * 0.4) * d3);
        this.dirX = d / d4 * 0.1;
        this.dirY = d2 / d4 * 0.1;
        this.dirZ = d3 / d4 * 0.1;
    }

    public void h_() {
        if (!this.world.isStatic && (this.shooter != null && this.shooter.dead || !this.world.isLoaded((int)this.locX, (int)this.locY, (int)this.locZ))) {
            this.die();
            return;
        }
        super.h_();
        this.setOnFire(1);
        if (this.i) {
            int n = this.world.getTypeId(this.e, this.f, this.g);
            if (n == this.h) {
                ++this.j;
                if (this.j == 600) {
                    this.die();
                }
                return;
            }
            this.i = false;
            this.motX *= (double)(this.random.nextFloat() * 0.2f);
            this.motY *= (double)(this.random.nextFloat() * 0.2f);
            this.motZ *= (double)(this.random.nextFloat() * 0.2f);
            this.j = 0;
            this.an = 0;
        } else {
            ++this.an;
        }
        Vec3D vec3D = Vec3D.a().create(this.locX, this.locY, this.locZ);
        Vec3D vec3D2 = Vec3D.a().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.a(vec3D, vec3D2);
        vec3D = Vec3D.a().create(this.locX, this.locY, this.locZ);
        vec3D2 = Vec3D.a().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            vec3D2 = Vec3D.a().create(movingObjectPosition.pos.a, movingObjectPosition.pos.b, movingObjectPosition.pos.c);
        }
        Entity entity = null;
        List list = this.world.getEntities(this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (Entity entity2 : list) {
            double d2;
            float f;
            AxisAlignedBB axisAlignedBB;
            MovingObjectPosition movingObjectPosition2;
            if (!entity2.L() || entity2.i(this.shooter) && this.an < 25 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.grow(f = 0.3f, f, f)).a(vec3D, vec3D2)) == null || !((d2 = vec3D.d(movingObjectPosition2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null) {
            this.a(movingObjectPosition);
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f2 = 0.95f;
        if (this.H()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.world.a("bubble", this.locX - this.motX * (double)f3, this.locY - this.motY * (double)f3, this.locZ - this.motZ * (double)f3, this.motX, this.motY, this.motZ);
            }
            f2 = 0.8f;
        }
        this.motX += this.dirX;
        this.motY += this.dirY;
        this.motZ += this.dirZ;
        this.motX *= (double)f2;
        this.motY *= (double)f2;
        this.motZ *= (double)f2;
        this.world.a("smoke", this.locX, this.locY + 0.5, this.locZ, 0.0, 0.0, 0.0);
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    protected void a(MovingObjectPosition movingObjectPosition) {
        if (!this.world.isStatic) {
            if (movingObjectPosition.entity != null) {
                movingObjectPosition.entity.damageEntity(DamageSource.fireball(this, this.shooter), 6);
            }
            this.world.createExplosion(null, this.locX, this.locY, this.locZ, 1.0f, true);
            this.die();
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.e);
        nBTTagCompound.setShort("yTile", (short)this.f);
        nBTTagCompound.setShort("zTile", (short)this.g);
        nBTTagCompound.setByte("inTile", (byte)this.h);
        nBTTagCompound.setByte("inGround", (byte)(this.i ? 1 : 0));
        nBTTagCompound.set("direction", this.a(this.motX, this.motY, this.motZ));
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.e = nBTTagCompound.getShort("xTile");
        this.f = nBTTagCompound.getShort("yTile");
        this.g = nBTTagCompound.getShort("zTile");
        this.h = nBTTagCompound.getByte("inTile") & 0xFF;
        boolean bl = this.i = nBTTagCompound.getByte("inGround") == 1;
        if (nBTTagCompound.hasKey("direction")) {
            NBTTagList nBTTagList = nBTTagCompound.getList("direction");
            this.motX = ((NBTTagDouble)nBTTagList.get((int)0)).data;
            this.motY = ((NBTTagDouble)nBTTagList.get((int)1)).data;
            this.motZ = ((NBTTagDouble)nBTTagList.get((int)2)).data;
        } else {
            this.die();
        }
    }

    public boolean L() {
        return true;
    }

    public float Y() {
        return 1.0f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.K();
        if (damageSource.getEntity() != null) {
            Vec3D vec3D = damageSource.getEntity().Z();
            if (vec3D != null) {
                this.motX = vec3D.a;
                this.motY = vec3D.b;
                this.motZ = vec3D.c;
                this.dirX = this.motX * 0.1;
                this.dirY = this.motY * 0.1;
                this.dirZ = this.motZ * 0.1;
            }
            if (damageSource.getEntity() instanceof EntityLiving) {
                this.shooter = (EntityLiving)damageSource.getEntity();
            }
            return true;
        }
        return false;
    }

    public float c(float f) {
        return 1.0f;
    }
}

