/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CherryPickCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.StashApplyCommand;
import org.eclipse.jgit.api.StashCreateCommand;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

public class Git
implements AutoCloseable {
    private final Repository repo;
    private final boolean closeRepo;

    public static Git open(File dir) throws IOException {
        return Git.open(dir, FS.DETECTED);
    }

    public static Git open(File dir, FS fs) throws IOException {
        RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient(dir, fs);
        Object db = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(fs)).setGitDir(key.getFile())).setMustExist(true)).build();
        return new Git((Repository)db, true);
    }

    public static Git wrap(Repository repo) {
        return new Git(repo);
    }

    @Override
    public void close() {
        if (this.closeRepo) {
            this.repo.close();
        }
    }

    public static CloneCommand cloneRepository() {
        return new CloneCommand();
    }

    public static InitCommand init() {
        return new InitCommand();
    }

    public Git(Repository repo) {
        this(repo, false);
    }

    Git(Repository repo, boolean closeRepo) {
        this.repo = Objects.requireNonNull(repo);
        this.closeRepo = closeRepo;
    }

    public CommitCommand commit() {
        return new CommitCommand(this.repo);
    }

    public LogCommand log() {
        return new LogCommand(this.repo);
    }

    public MergeCommand merge() {
        return new MergeCommand(this.repo);
    }

    public CreateBranchCommand branchCreate() {
        return new CreateBranchCommand(this.repo);
    }

    public DeleteBranchCommand branchDelete() {
        return new DeleteBranchCommand(this.repo);
    }

    public AddCommand add() {
        return new AddCommand(this.repo);
    }

    public FetchCommand fetch() {
        return new FetchCommand(this.repo);
    }

    public CherryPickCommand cherryPick() {
        return new CherryPickCommand(this.repo);
    }

    public CheckoutCommand checkout() {
        return new CheckoutCommand(this.repo);
    }

    public ResetCommand reset() {
        return new ResetCommand(this.repo);
    }

    public StatusCommand status() {
        return new StatusCommand(this.repo);
    }

    public StashCreateCommand stashCreate() {
        return new StashCreateCommand(this.repo);
    }

    public StashApplyCommand stashApply() {
        return new StashApplyCommand(this.repo);
    }

    public Repository getRepository() {
        return this.repo;
    }

    public String toString() {
        return "Git[" + this.repo + "]";
    }
}

