/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;

public class LfsFactory {
    private static LfsFactory instance = new LfsFactory();

    protected LfsFactory() {
    }

    public static LfsFactory getInstance() {
        return instance;
    }

    public boolean isAvailable() {
        return false;
    }

    public LfsInputStream applyCleanFilter(Repository db, InputStream input, long length, Attribute attribute) throws IOException {
        return new LfsInputStream(input, length);
    }

    public ObjectLoader applySmudgeFilter(Repository db, ObjectLoader loader, Attribute attribute) throws IOException {
        return loader;
    }

    public PrePushHook getPrePushHook(Repository repo, PrintStream outputStream) {
        return null;
    }

    public static final class LfsInputStream
    extends InputStream {
        private InputStream stream;
        private long length;

        public LfsInputStream(InputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long getLength() {
            return this.length;
        }
    }
}

