/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.javafinder;

import com.jeff_media.javafinder.JavaInstallation;
import com.jeff_media.javafinder.JavaType;
import com.jeff_media.javafinder.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class DirectoryCrawler {
    private final File searchDir;
    private final List<JavaInstallation> installations = new ArrayList<JavaInstallation>();
    private final String javaExecutableName;
    private final String javacExecutableName;

    DirectoryCrawler(File searchDir, OperatingSystem os) {
        this.searchDir = searchDir;
        this.javaExecutableName = os.getJavaExecutableName();
        this.javacExecutableName = os.getJavacExecutableName();
    }

    List<JavaInstallation> findInstallations() {
        this.findInstallations(this.searchDir);
        return this.installations;
    }

    private void findInstallations(File searchDir) {
        File[] children = searchDir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (!file.isDirectory()) continue;
                if (file.getName().equals("bin")) {
                    File javaExecutable = new File(file, this.javaExecutableName);
                    File javaCExecutable = new File(file, this.javacExecutableName);
                    boolean isJdk = javaCExecutable.canExecute();
                    if (!javaExecutable.canExecute()) continue;
                    try {
                        this.installations.add(new JavaInstallation(searchDir, javaExecutable, isJdk ? javaCExecutable : null, isJdk ? JavaType.JDK : JavaType.JRE));
                    }
                    catch (IOException ignored) {
                        ignored.printStackTrace();
                    }
                    continue;
                }
                this.findInstallations(file);
            }
        }
    }
}

