/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(StandardCharsets.UTF_8, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectReader or = db.newObjectReader();){
            return BlobBasedConfig.read(or, blobId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }
}

