// Generated by delombok at Tue Dec 16 19:36:13 UTC 2025
package net.md_5.bungee.util;

public final class AllowedCharacters {
    public static boolean isChatAllowedCharacter(char character) {
        // Section symbols, control sequences, and deletes are not allowed
        return character != '§' && character >= ' ' && character != 127;
    }

    private static boolean isNameAllowedCharacter(char c, boolean onlineMode) {
        if (onlineMode) {
            return (c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || c == '_';
        } else {
            // Don't allow spaces, Yaml config doesn't support them
            return isChatAllowedCharacter(c) && c != ' ';
        }
    }

    public static boolean isValidName(String name, boolean onlineMode) {
        if (name.isEmpty() || name.length() > 16) {
            return false;
        }
        for (int index = 0, len = name.length(); index < len; index++) {
            if (!isNameAllowedCharacter(name.charAt(index), onlineMode)) {
                return false;
            }
        }
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private AllowedCharacters() {
    }
}
