// Generated by delombok at Sun Oct 26 00:53:19 UTC 2025
package net.md_5.bungee.scheduler;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class BungeeTask implements Runnable, ScheduledTask {
    private final BungeeScheduler sched;
    private final int id;
    private final Plugin owner;
    private final Runnable task;
    //
    private final long delay;
    private final long period;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public BungeeTask(BungeeScheduler sched, int id, Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        this.sched = sched;
        this.id = id;
        this.owner = owner;
        this.task = task;
        this.delay = unit.toMillis(delay);
        this.period = unit.toMillis(period);
    }

    @Override
    public void cancel() {
        boolean wasRunning = running.getAndSet(false);
        if (wasRunning) {
            sched.cancel0(this);
        }
    }

    @Override
    public void run() {
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            } catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        while (running.get()) {
            try {
                task.run();
            } catch (Throwable t) {
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Task " + this + " encountered an exception", t);
            }
            // If we have a period of 0 or less, only run once
            if (period <= 0) {
                break;
            }
            try {
                Thread.sleep(period);
            } catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        cancel();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BungeeScheduler getSched() {
        return this.sched;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getId() {
        return this.id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Plugin getOwner() {
        return this.owner;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Runnable getTask() {
        return this.task;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getDelay() {
        return this.delay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getPeriod() {
        return this.period;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtomicBoolean getRunning() {
        return this.running;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof BungeeTask)) return false;
        final BungeeTask other = (BungeeTask) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getId() != other.getId()) return false;
        if (this.getDelay() != other.getDelay()) return false;
        if (this.getPeriod() != other.getPeriod()) return false;
        final java.lang.Object this$sched = this.getSched();
        final java.lang.Object other$sched = other.getSched();
        if (this$sched == null ? other$sched != null : !this$sched.equals(other$sched)) return false;
        final java.lang.Object this$owner = this.getOwner();
        final java.lang.Object other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) return false;
        final java.lang.Object this$task = this.getTask();
        final java.lang.Object other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) return false;
        final java.lang.Object this$running = this.getRunning();
        final java.lang.Object other$running = other.getRunning();
        if (this$running == null ? other$running != null : !this$running.equals(other$running)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof BungeeTask;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getId();
        final long $delay = this.getDelay();
        result = result * PRIME + (int) ($delay >>> 32 ^ $delay);
        final long $period = this.getPeriod();
        result = result * PRIME + (int) ($period >>> 32 ^ $period);
        final java.lang.Object $sched = this.getSched();
        result = result * PRIME + ($sched == null ? 43 : $sched.hashCode());
        final java.lang.Object $owner = this.getOwner();
        result = result * PRIME + ($owner == null ? 43 : $owner.hashCode());
        final java.lang.Object $task = this.getTask();
        result = result * PRIME + ($task == null ? 43 : $task.hashCode());
        final java.lang.Object $running = this.getRunning();
        result = result * PRIME + ($running == null ? 43 : $running.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "BungeeTask(sched=" + this.getSched() + ", id=" + this.getId() + ", owner=" + this.getOwner() + ", task=" + this.getTask() + ", delay=" + this.getDelay() + ", period=" + this.getPeriod() + ", running=" + this.getRunning() + ")";
    }
}
