// Generated by delombok at Sun Oct 26 00:53:19 UTC 2025
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
// CHECKSTYLE:OFF
// CHECKSTYLE:ON
public class BungeeServerInfo implements ServerInfo {
    private final String name;
    private final SocketAddress socketAddress;
    private final Collection<ProxiedPlayer> players = new ArrayList<>();
    private final String motd;
    private final boolean restricted;
    private final Queue<DefinedPacket> packetQueue = new LinkedList<>();

    public void addPlayer(ProxiedPlayer player) {
        synchronized (this.players) {
            players.add(player);
        }
    }

    public void removePlayer(ProxiedPlayer player) {
        synchronized (this.players) {
            players.remove(player);
        }
    }

    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        synchronized (this.players) {
            return Collections.unmodifiableCollection(new HashSet<>(players));
        }
    }

    @Override
    public String getPermission() {
        return "bungeecord.server." + name;
    }

    @Override
    public boolean canAccess(CommandSender player) {
        Preconditions.checkNotNull(player, "player");
        return !restricted || player.hasPermission(getPermission());
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof ServerInfo) && Objects.equals(getAddress(), ((ServerInfo) obj).getAddress());
    }

    @Override
    public int hashCode() {
        return socketAddress.hashCode();
    }

    @Override
    public void sendData(String channel, byte[] data) {
        sendData(channel, data, true);
    }

    @Override
    public boolean sendData(String channel, byte[] data, boolean queue) {
        Preconditions.checkNotNull(channel, "channel");
        Preconditions.checkNotNull(data, "data");
        Server server;
        synchronized (players) {
            server = (players.isEmpty()) ? null : players.iterator().next().getServer();
        }
        if (server != null) {
            server.sendData(channel, data);
            return true;
        } else if (queue) {
            synchronized (packetQueue) {
                packetQueue.add(new PluginMessage(channel, data, false));
            }
        }
        return false;
    }

    private long lastPing;
    private ServerPing cachedPing;

    public void cachePing(ServerPing serverPing) {
        if (ProxyServer.getInstance().getConfig().getRemotePingCache() > 0) {
            this.cachedPing = serverPing;
            this.lastPing = System.currentTimeMillis();
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress) socketAddress;
    }

    @Override
    public void ping(final Callback<ServerPing> callback) {
        ping(callback, ProxyServer.getInstance().getProtocolVersion());
    }

    public void ping(final Callback<ServerPing> callback, final int protocolVersion) {
        Preconditions.checkNotNull(callback, "callback");
        int pingCache = ProxyServer.getInstance().getConfig().getRemotePingCache();
        if (pingCache > 0 && cachedPing != null && (System.currentTimeMillis() - lastPing) > pingCache) {
            cachedPing = null;
        }
        if (cachedPing != null) {
            callback.done(cachedPing, null);
            return;
        }
        ChannelFutureListener listener = new ChannelFutureListener() {
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    future.channel().pipeline().get(HandlerBoss.class).setHandler(new PingHandler(BungeeServerInfo.this, callback, protocolVersion));
                } else {
                    callback.done(null, future.cause());
                }
            }
        };
        new Bootstrap().channel(PipelineUtils.getChannel(socketAddress)).group(BungeeCord.getInstance().eventLoops).handler(ProxyServer.getInstance().unsafe().getServerInfoChannelInitializer().getChannelInitializer()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, BungeeCord.getInstance().getConfig().getRemotePingTimeout()).remoteAddress(socketAddress).connect().addListener(listener);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BungeeServerInfo(final String name, final SocketAddress socketAddress, final String motd, final boolean restricted) {
        this.name = name;
        this.socketAddress = socketAddress;
        this.motd = motd;
        this.restricted = restricted;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "BungeeServerInfo(name=" + this.getName() + ", socketAddress=" + this.getSocketAddress() + ", restricted=" + this.isRestricted() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMotd() {
        return this.motd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isRestricted() {
        return this.restricted;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Queue<DefinedPacket> getPacketQueue() {
        return this.packetQueue;
    }
}
