/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.OverflowPacketException;

public class PacketDecompressor
extends MessageToMessageDecoder<ByteBuf> {
    private static final int MAX_DECOMPRESSED_LEN = 0x800000;
    private final BungeeZlib zlib = (BungeeZlib)CompressFactory.zlib.newInstance();

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.zlib.init(false, 0);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.zlib.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int size = DefinedPacket.readVarInt((ByteBuf)in);
        if (size == 0) {
            out.add(in.retain());
        } else {
            if (size > 0x800000) {
                throw new OverflowPacketException("Packet may not be larger than 8388608 bytes");
            }
            ByteBuf decompressed = ctx.alloc().directBuffer(size, 0x800000);
            try {
                this.zlib.process(in, decompressed);
                Preconditions.checkState((decompressed.readableBytes() == size ? 1 : 0) != 0, (Object)"Decompressed packet size mismatch");
                out.add(decompressed);
                decompressed = null;
            }
            finally {
                if (decompressed != null) {
                    decompressed.release();
                }
            }
        }
    }
}

