// Generated by delombok at Fri Nov 21 22:30:13 UTC 2025
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a textbox input.
 */
public class TextInput extends DialogInput {
    /**
     * The width of this text input (default: 200, minimum: 1, maximum: 1024).
     */
    private Integer width;
    /**
     * The label of this text input.
     */
    @NonNull
    private BaseComponent label;
    /**
     * The visibility of this text input's label.
     */
    @SerializedName("label_visible")
    private Boolean labelVisible;
    /**
     * The initial value of this text input.
     */
    private String initial;
    /**
     * The maximum length of the input (default: 32).
     */
    @SerializedName("max_length")
    private Integer maxLength;
    /**
     * If present, allows users to input multiple lines.
     */
    private Multiline multiline;

    public TextInput(@NonNull String key, @NonNull BaseComponent label) {
        this(key, null, label, null, null, null, null);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
    }

    public TextInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, String initial, Integer maxLength) {
        this(key, width, label, labelVisible, initial, maxLength, null);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
    }

    public TextInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, String initial, Integer maxLength, Multiline multiline) {
        super("minecraft:text", key);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        width(width);
        this.label = label;
        this.labelVisible = labelVisible;
        this.initial = initial;
        this.maxLength = maxLength;
        this.multiline = multiline;
    }


    /**
     * Configuration data for a multiline input.
     */
    public static class Multiline {
        /**
         * The maximum length of input, or null to disable any limits.
         */
        @SerializedName("max_lines")
        private Integer maxLines;
        /**
         * The height of this input (default: 32, minimum: 1, maximum: 512).
         */
        private Integer height;

        public Multiline(Integer maxLines, Integer height) {
            height(height).maxLines(maxLines);
        }

        public Multiline height(Integer height) {
            Preconditions.checkArgument(height == null || height >= 1 && height <= 512, "height must null or be between 1 and 512");
            this.height = height;
            return this;
        }

        /**
         * The maximum length of input, or null to disable any limits.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer maxLines() {
            return this.maxLines;
        }

        /**
         * The height of this input (default: 32, minimum: 1, maximum: 512).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer height() {
            return this.height;
        }

        /**
         * The maximum length of input, or null to disable any limits.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TextInput.Multiline maxLines(final Integer maxLines) {
            this.maxLines = maxLines;
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TextInput.Multiline)) return false;
            final TextInput.Multiline other = (TextInput.Multiline) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$maxLines = this.maxLines();
            final java.lang.Object other$maxLines = other.maxLines();
            if (this$maxLines == null ? other$maxLines != null : !this$maxLines.equals(other$maxLines)) return false;
            final java.lang.Object this$height = this.height();
            final java.lang.Object other$height = other.height();
            if (this$height == null ? other$height != null : !this$height.equals(other$height)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof TextInput.Multiline;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $maxLines = this.maxLines();
            result = result * PRIME + ($maxLines == null ? 43 : $maxLines.hashCode());
            final java.lang.Object $height = this.height();
            result = result * PRIME + ($height == null ? 43 : $height.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TextInput.Multiline(maxLines=" + this.maxLines() + ", height=" + this.height() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Multiline() {
        }
    }

    public TextInput width(Integer width) {
        Preconditions.checkArgument(width == null || (width >= 1 && width <= 1024), "width must be between 1 and 1024");
        this.width = width;
        return this;
    }

    /**
     * The width of this text input (default: 200, minimum: 1, maximum: 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer width() {
        return this.width;
    }

    /**
     * The label of this text input.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent label() {
        return this.label;
    }

    /**
     * The visibility of this text input's label.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean labelVisible() {
        return this.labelVisible;
    }

    /**
     * The initial value of this text input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String initial() {
        return this.initial;
    }

    /**
     * The maximum length of the input (default: 32).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer maxLength() {
        return this.maxLength;
    }

    /**
     * If present, allows users to input multiple lines.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Multiline multiline() {
        return this.multiline;
    }

    /**
     * The label of this text input.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TextInput label(@NonNull final BaseComponent label) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    /**
     * The visibility of this text input's label.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TextInput labelVisible(final Boolean labelVisible) {
        this.labelVisible = labelVisible;
        return this;
    }

    /**
     * The initial value of this text input.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TextInput initial(final String initial) {
        this.initial = initial;
        return this;
    }

    /**
     * The maximum length of the input (default: 32).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TextInput maxLength(final Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    /**
     * If present, allows users to input multiple lines.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TextInput multiline(final Multiline multiline) {
        this.multiline = multiline;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TextInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelVisible=" + this.labelVisible() + ", initial=" + this.initial() + ", maxLength=" + this.maxLength() + ", multiline=" + this.multiline() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TextInput)) return false;
        final TextInput other = (TextInput) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$width = this.width();
        final java.lang.Object other$width = other.width();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
        final java.lang.Object this$labelVisible = this.labelVisible();
        final java.lang.Object other$labelVisible = other.labelVisible();
        if (this$labelVisible == null ? other$labelVisible != null : !this$labelVisible.equals(other$labelVisible)) return false;
        final java.lang.Object this$maxLength = this.maxLength();
        final java.lang.Object other$maxLength = other.maxLength();
        if (this$maxLength == null ? other$maxLength != null : !this$maxLength.equals(other$maxLength)) return false;
        final java.lang.Object this$label = this.label();
        final java.lang.Object other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$initial = this.initial();
        final java.lang.Object other$initial = other.initial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) return false;
        final java.lang.Object this$multiline = this.multiline();
        final java.lang.Object other$multiline = other.multiline();
        if (this$multiline == null ? other$multiline != null : !this$multiline.equals(other$multiline)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TextInput;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $width = this.width();
        result = result * PRIME + ($width == null ? 43 : $width.hashCode());
        final java.lang.Object $labelVisible = this.labelVisible();
        result = result * PRIME + ($labelVisible == null ? 43 : $labelVisible.hashCode());
        final java.lang.Object $maxLength = this.maxLength();
        result = result * PRIME + ($maxLength == null ? 43 : $maxLength.hashCode());
        final java.lang.Object $label = this.label();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $initial = this.initial();
        result = result * PRIME + ($initial == null ? 43 : $initial.hashCode());
        final java.lang.Object $multiline = this.multiline();
        result = result * PRIME + ($multiline == null ? 43 : $multiline.hashCode());
        return result;
    }
}
