// Generated by delombok at Fri Nov 21 22:30:13 UTC 2025
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a single option (dropdown) input.
 */
public class SingleOptionInput extends DialogInput {
    /**
     * The width of the input (default: 200, minimum: 1, maximum: 1024).
     */
    private Integer width;
    /**
     * The input label.
     */
    @NonNull
    private BaseComponent label;
    /**
     * Whether the label is visible (default: true).
     */
    @SerializedName("label_visible")
    private Boolean labelVisible;
    /**
     * The non-empty list of options to be selected from.
     */
    @NonNull
    private List<InputOption> options;

    public SingleOptionInput(@NonNull String key, @NonNull BaseComponent label, @NonNull InputOption... options) {
        this(key, null, label, null, Arrays.asList(options));
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        if (options == null) {
            throw new java.lang.NullPointerException("options is marked non-null but is null");
        }
    }

    public SingleOptionInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, @NonNull List<InputOption> options) {
        super("minecraft:single_option", key);
        if (key == null) {
            throw new java.lang.NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        if (options == null) {
            throw new java.lang.NullPointerException("options is marked non-null but is null");
        }
        Preconditions.checkArgument(!options.isEmpty(), "At least one option must be provided");
        width(width);
        this.label = label;
        this.labelVisible = labelVisible;
        this.options = options;
    }

    public SingleOptionInput width(Integer width) {
        Preconditions.checkArgument(width == null || (width >= 1 && width <= 1024), "width must be between 1 and 1024");
        this.width = width;
        return this;
    }

    /**
     * The width of the input (default: 200, minimum: 1, maximum: 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer width() {
        return this.width;
    }

    /**
     * The input label.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent label() {
        return this.label;
    }

    /**
     * Whether the label is visible (default: true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean labelVisible() {
        return this.labelVisible;
    }

    /**
     * The non-empty list of options to be selected from.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<InputOption> options() {
        return this.options;
    }

    /**
     * The input label.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SingleOptionInput label(@NonNull final BaseComponent label) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    /**
     * Whether the label is visible (default: true).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SingleOptionInput labelVisible(final Boolean labelVisible) {
        this.labelVisible = labelVisible;
        return this;
    }

    /**
     * The non-empty list of options to be selected from.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SingleOptionInput options(@NonNull final List<InputOption> options) {
        if (options == null) {
            throw new java.lang.NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SingleOptionInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelVisible=" + this.labelVisible() + ", options=" + this.options() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SingleOptionInput)) return false;
        final SingleOptionInput other = (SingleOptionInput) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$width = this.width();
        final java.lang.Object other$width = other.width();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
        final java.lang.Object this$labelVisible = this.labelVisible();
        final java.lang.Object other$labelVisible = other.labelVisible();
        if (this$labelVisible == null ? other$labelVisible != null : !this$labelVisible.equals(other$labelVisible)) return false;
        final java.lang.Object this$label = this.label();
        final java.lang.Object other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$options = this.options();
        final java.lang.Object other$options = other.options();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SingleOptionInput;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $width = this.width();
        result = result * PRIME + ($width == null ? 43 : $width.hashCode());
        final java.lang.Object $labelVisible = this.labelVisible();
        result = result * PRIME + ($labelVisible == null ? 43 : $labelVisible.hashCode());
        final java.lang.Object $label = this.label();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $options = this.options();
        result = result * PRIME + ($options == null ? 43 : $options.hashCode());
        return result;
    }
}
