// Generated by delombok at Fri Nov 21 22:30:13 UTC 2025
package net.md_5.bungee.api.dialog.body;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a dialog body which consists of text constrained to a certain
 * width.
 */
public class PlainMessageBody extends DialogBody {
    /**
     * The text body.
     */
    @NonNull
    private BaseComponent contents;
    /**
     * The maximum width (default: 200, minimum: 1, maximum: 1024).
     */
    private Integer width;

    public PlainMessageBody(@NonNull BaseComponent contents) {
        this(contents, null);
        if (contents == null) {
            throw new java.lang.NullPointerException("contents is marked non-null but is null");
        }
    }

    public PlainMessageBody(@NonNull BaseComponent contents, Integer width) {
        super("minecraft:plain_message");
        if (contents == null) {
            throw new java.lang.NullPointerException("contents is marked non-null but is null");
        }
        this.contents = contents;
        width(width);
    }

    public void width(Integer width) {
        Preconditions.checkArgument(width == null || (width >= 1 && width <= 1024), "width must be between 1 and 1024");
        this.width = width;
    }

    /**
     * The text body.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent contents() {
        return this.contents;
    }

    /**
     * The maximum width (default: 200, minimum: 1, maximum: 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer width() {
        return this.width;
    }

    /**
     * The text body.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PlainMessageBody contents(@NonNull final BaseComponent contents) {
        if (contents == null) {
            throw new java.lang.NullPointerException("contents is marked non-null but is null");
        }
        this.contents = contents;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PlainMessageBody(super=" + super.toString() + ", contents=" + this.contents() + ", width=" + this.width() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PlainMessageBody)) return false;
        final PlainMessageBody other = (PlainMessageBody) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$width = this.width();
        final java.lang.Object other$width = other.width();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
        final java.lang.Object this$contents = this.contents();
        final java.lang.Object other$contents = other.contents();
        if (this$contents == null ? other$contents != null : !this$contents.equals(other$contents)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PlainMessageBody;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $width = this.width();
        result = result * PRIME + ($width == null ? 43 : $width.hashCode());
        final java.lang.Object $contents = this.contents();
        result = result * PRIME + ($contents == null ? 43 : $contents.hashCode());
        return result;
    }
}
