// Generated by delombok at Fri Nov 21 22:30:13 UTC 2025
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import net.md_5.bungee.api.dialog.action.ActionButton;

/**
 * Represents a dialog with text a list of action buttons grouped into columns
 * and scrollable if necessary.
 */
public final class MultiActionDialog implements Dialog {
    @NonNull
    private DialogBase base;
    /**
     * The action buttons in the dialog. At least one must be provided.
     */
    @NonNull
    private List<ActionButton> actions;
    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    private Integer columns;
    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @SerializedName("exit_action")
    private ActionButton exitAction;

    public MultiActionDialog(@NonNull DialogBase base, @NonNull ActionButton... actions) {
        this(base, Arrays.asList(actions), null, null);
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new java.lang.NullPointerException("actions is marked non-null but is null");
        }
    }

    public MultiActionDialog(@NonNull DialogBase base, @NonNull List<ActionButton> actions, Integer columns, ActionButton exitAction) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new java.lang.NullPointerException("actions is marked non-null but is null");
        }
        Preconditions.checkArgument(!actions.isEmpty(), "At least one action must be provided");
        this.base = base;
        this.actions = actions;
        columns(columns);
        this.exitAction = exitAction;
    }

    public MultiActionDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase getBase() {
        return this.base;
    }

    /**
     * The action buttons in the dialog. At least one must be provided.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ActionButton> actions() {
        return this.actions;
    }

    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer columns() {
        return this.columns;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton exitAction() {
        return this.exitAction;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBase(@NonNull final DialogBase base) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    /**
     * The action buttons in the dialog. At least one must be provided.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MultiActionDialog actions(@NonNull final List<ActionButton> actions) {
        if (actions == null) {
            throw new java.lang.NullPointerException("actions is marked non-null but is null");
        }
        this.actions = actions;
        return this;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MultiActionDialog exitAction(final ActionButton exitAction) {
        this.exitAction = exitAction;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MultiActionDialog(base=" + this.getBase() + ", actions=" + this.actions() + ", columns=" + this.columns() + ", exitAction=" + this.exitAction() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MultiActionDialog)) return false;
        final MultiActionDialog other = (MultiActionDialog) o;
        final java.lang.Object this$columns = this.columns();
        final java.lang.Object other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$base = this.getBase();
        final java.lang.Object other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) return false;
        final java.lang.Object this$actions = this.actions();
        final java.lang.Object other$actions = other.actions();
        if (this$actions == null ? other$actions != null : !this$actions.equals(other$actions)) return false;
        final java.lang.Object this$exitAction = this.exitAction();
        final java.lang.Object other$exitAction = other.exitAction();
        if (this$exitAction == null ? other$exitAction != null : !this$exitAction.equals(other$exitAction)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $columns = this.columns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $base = this.getBase();
        result = result * PRIME + ($base == null ? 43 : $base.hashCode());
        final java.lang.Object $actions = this.actions();
        result = result * PRIME + ($actions == null ? 43 : $actions.hashCode());
        final java.lang.Object $exitAction = this.exitAction();
        result = result * PRIME + ($exitAction == null ? 43 : $exitAction.hashCode());
        return result;
    }
}
