// Generated by delombok at Fri Nov 21 22:30:13 UTC 2025
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import net.md_5.bungee.api.dialog.action.ActionButton;

/**
 * Represents a dialog which contains buttons that link to other dialogs.
 */
public final class DialogListDialog implements Dialog {
    @NonNull
    private DialogBase base;
    /**
     * The child dialogs behind each button.
     */
    private List<Dialog> dialogs;
    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @SerializedName("exit_action")
    private ActionButton exitAction;
    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    private Integer columns;
    /**
     * The width of the dialog buttons (default: 150, minimum: 1, maximum:
     * 1024).
     */
    @SerializedName("button_width")
    private Integer buttonWidth;

    public DialogListDialog(@NonNull DialogBase base, Dialog... dialogs) {
        this(base, Arrays.asList(dialogs), null, null, null);
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
    }

    public DialogListDialog(@NonNull DialogBase base, List<Dialog> dialogs, ActionButton exitAction, Integer columns, Integer buttonWidth) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
        this.dialogs = dialogs;
        this.exitAction = exitAction;
        columns(columns);
        buttonWidth(buttonWidth);
    }

    public DialogListDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    public DialogListDialog buttonWidth(Integer buttonWidth) {
        Preconditions.checkArgument(buttonWidth == null || (buttonWidth >= 1 && buttonWidth <= 1024), "buttonWidth must be between 1 and 1024");
        this.buttonWidth = buttonWidth;
        return this;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase getBase() {
        return this.base;
    }

    /**
     * The child dialogs behind each button.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Dialog> dialogs() {
        return this.dialogs;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton exitAction() {
        return this.exitAction;
    }

    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer columns() {
        return this.columns;
    }

    /**
     * The width of the dialog buttons (default: 150, minimum: 1, maximum:
     * 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer buttonWidth() {
        return this.buttonWidth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBase(@NonNull final DialogBase base) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    /**
     * The child dialogs behind each button.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogListDialog dialogs(final List<Dialog> dialogs) {
        this.dialogs = dialogs;
        return this;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogListDialog exitAction(final ActionButton exitAction) {
        this.exitAction = exitAction;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DialogListDialog(base=" + this.getBase() + ", dialogs=" + this.dialogs() + ", exitAction=" + this.exitAction() + ", columns=" + this.columns() + ", buttonWidth=" + this.buttonWidth() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DialogListDialog)) return false;
        final DialogListDialog other = (DialogListDialog) o;
        final java.lang.Object this$columns = this.columns();
        final java.lang.Object other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$buttonWidth = this.buttonWidth();
        final java.lang.Object other$buttonWidth = other.buttonWidth();
        if (this$buttonWidth == null ? other$buttonWidth != null : !this$buttonWidth.equals(other$buttonWidth)) return false;
        final java.lang.Object this$base = this.getBase();
        final java.lang.Object other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) return false;
        final java.lang.Object this$dialogs = this.dialogs();
        final java.lang.Object other$dialogs = other.dialogs();
        if (this$dialogs == null ? other$dialogs != null : !this$dialogs.equals(other$dialogs)) return false;
        final java.lang.Object this$exitAction = this.exitAction();
        final java.lang.Object other$exitAction = other.exitAction();
        if (this$exitAction == null ? other$exitAction != null : !this$exitAction.equals(other$exitAction)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $columns = this.columns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $buttonWidth = this.buttonWidth();
        result = result * PRIME + ($buttonWidth == null ? 43 : $buttonWidth.hashCode());
        final java.lang.Object $base = this.getBase();
        result = result * PRIME + ($base == null ? 43 : $base.hashCode());
        final java.lang.Object $dialogs = this.dialogs();
        result = result * PRIME + ($dialogs == null ? 43 : $dialogs.hashCode());
        final java.lang.Object $exitAction = this.exitAction();
        result = result * PRIME + ($exitAction == null ? 43 : $exitAction.hashCode());
        return result;
    }
}
