// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.util.Either;

public class Team extends DefinedPacket {
    private String name;
    /**
     * 0 - create, 1 remove, 2 info update, 3 player add, 4 player remove.
     */
    private byte mode;
    private Either<String, BaseComponent> displayName;
    private Either<String, BaseComponent> prefix;
    private Either<String, BaseComponent> suffix;
    //
    private Either<String, NameTagVisibility> nameTagVisibility;
    private Either<String, CollisionRule> collisionRule;
    //
    private int color;
    private byte friendlyFire;
    private String[] players;

    /**
     * Packet to destroy a team.
     *
     * @param name team name
     */
    public Team(String name) {
        this.name = name;
        this.mode = 1;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        name = readString(buf);
        mode = buf.readByte();
        if (mode == 0 || mode == 2) {
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_13) {
                displayName = readEitherBaseComponent(buf, protocolVersion, true);
                prefix = readEitherBaseComponent(buf, protocolVersion, true);
                suffix = readEitherBaseComponent(buf, protocolVersion, true);
            } else {
                displayName = readEitherBaseComponent(buf, protocolVersion, false);
            }
            friendlyFire = buf.readByte();
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
                nameTagVisibility = Either.right(NameTagVisibility.BY_ID[readVarInt(buf)]);
                collisionRule = Either.right(CollisionRule.BY_ID[readVarInt(buf)]);
            } else {
                nameTagVisibility = Either.left(readString(buf));
                if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
                    collisionRule = Either.left(readString(buf));
                }
            }
            color = (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) ? readVarInt(buf) : buf.readByte();
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
                prefix = readEitherBaseComponent(buf, protocolVersion, false);
                suffix = readEitherBaseComponent(buf, protocolVersion, false);
            }
        }
        if (mode == 0 || mode == 3 || mode == 4) {
            int len = readVarInt(buf);
            players = new String[len];
            for (int i = 0; i < len; i++) {
                players[i] = readString(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(name, buf);
        buf.writeByte(mode);
        if (mode == 0 || mode == 2) {
            writeEitherBaseComponent(displayName, buf, protocolVersion);
            if (protocolVersion < ProtocolConstants.MINECRAFT_1_13) {
                writeEitherBaseComponent(prefix, buf, protocolVersion);
                writeEitherBaseComponent(suffix, buf, protocolVersion);
            }
            buf.writeByte(friendlyFire);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
                writeVarInt(nameTagVisibility.getRight().ordinal(), buf);
                writeVarInt(collisionRule.getRight().ordinal(), buf);
            } else {
                writeString(nameTagVisibility.getLeft(), buf);
                if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
                    writeString(collisionRule.getLeft(), buf);
                }
            }
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
                writeVarInt(color, buf);
                writeEitherBaseComponent(prefix, buf, protocolVersion);
                writeEitherBaseComponent(suffix, buf, protocolVersion);
            } else {
                buf.writeByte(color);
            }
        }
        if (mode == 0 || mode == 3 || mode == 4) {
            writeVarInt(players.length, buf);
            for (String player : players) {
                writeString(player, buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public enum NameTagVisibility {
        ALWAYS("always"), NEVER("never"), HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"), HIDE_FOR_OWN_TEAM("hideForOwnTeam");
        //
        private final String key;
        //
        private static final NameTagVisibility[] BY_ID = values();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getKey() {
            return this.key;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private NameTagVisibility(final String key) {
            this.key = key;
        }
    }


    public enum CollisionRule {
        ALWAYS("always"), NEVER("never"), PUSH_OTHER_TEAMS("pushOtherTeams"), PUSH_OWN_TEAM("pushOwnTeam");
        //
        private final String key;
        //
        private static final CollisionRule[] BY_ID = CollisionRule.values();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getKey() {
            return this.key;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CollisionRule(final String key) {
            this.key = key;
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * 0 - create, 1 remove, 2 info update, 3 player add, 4 player remove.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getMode() {
        return this.mode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, BaseComponent> getDisplayName() {
        return this.displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, BaseComponent> getPrefix() {
        return this.prefix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, BaseComponent> getSuffix() {
        return this.suffix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, NameTagVisibility> getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, CollisionRule> getCollisionRule() {
        return this.collisionRule;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getColor() {
        return this.color;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getFriendlyFire() {
        return this.friendlyFire;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String[] getPlayers() {
        return this.players;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * 0 - create, 1 remove, 2 info update, 3 player add, 4 player remove.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMode(final byte mode) {
        this.mode = mode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayName(final Either<String, BaseComponent> displayName) {
        this.displayName = displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPrefix(final Either<String, BaseComponent> prefix) {
        this.prefix = prefix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSuffix(final Either<String, BaseComponent> suffix) {
        this.suffix = suffix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNameTagVisibility(final Either<String, NameTagVisibility> nameTagVisibility) {
        this.nameTagVisibility = nameTagVisibility;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCollisionRule(final Either<String, CollisionRule> collisionRule) {
        this.collisionRule = collisionRule;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setColor(final int color) {
        this.color = color;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFriendlyFire(final byte friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPlayers(final String[] players) {
        this.players = players;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Team(name=" + this.getName() + ", mode=" + this.getMode() + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", nameTagVisibility=" + this.getNameTagVisibility() + ", collisionRule=" + this.getCollisionRule() + ", color=" + this.getColor() + ", friendlyFire=" + this.getFriendlyFire() + ", players=" + java.util.Arrays.deepToString(this.getPlayers()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Team() {
    }

    /**
     * Creates a new {@code Team} instance.
     *
     * @param name
     * @param mode 0 - create, 1 remove, 2 info update, 3 player add, 4 player remove.
     * @param displayName
     * @param prefix
     * @param suffix
     * @param nameTagVisibility
     * @param collisionRule
     * @param color
     * @param friendlyFire
     * @param players
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Team(final String name, final byte mode, final Either<String, BaseComponent> displayName, final Either<String, BaseComponent> prefix, final Either<String, BaseComponent> suffix, final Either<String, NameTagVisibility> nameTagVisibility, final Either<String, CollisionRule> collisionRule, final int color, final byte friendlyFire, final String[] players) {
        this.name = name;
        this.mode = mode;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.friendlyFire = friendlyFire;
        this.players = players;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Team)) return false;
        final Team other = (Team) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getMode() != other.getMode()) return false;
        if (this.getColor() != other.getColor()) return false;
        if (this.getFriendlyFire() != other.getFriendlyFire()) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$prefix = this.getPrefix();
        final java.lang.Object other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) return false;
        final java.lang.Object this$suffix = this.getSuffix();
        final java.lang.Object other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) return false;
        final java.lang.Object this$nameTagVisibility = this.getNameTagVisibility();
        final java.lang.Object other$nameTagVisibility = other.getNameTagVisibility();
        if (this$nameTagVisibility == null ? other$nameTagVisibility != null : !this$nameTagVisibility.equals(other$nameTagVisibility)) return false;
        final java.lang.Object this$collisionRule = this.getCollisionRule();
        final java.lang.Object other$collisionRule = other.getCollisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !this$collisionRule.equals(other$collisionRule)) return false;
        if (!java.util.Arrays.deepEquals(this.getPlayers(), other.getPlayers())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Team;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getMode();
        result = result * PRIME + this.getColor();
        result = result * PRIME + this.getFriendlyFire();
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $prefix = this.getPrefix();
        result = result * PRIME + ($prefix == null ? 43 : $prefix.hashCode());
        final java.lang.Object $suffix = this.getSuffix();
        result = result * PRIME + ($suffix == null ? 43 : $suffix.hashCode());
        final java.lang.Object $nameTagVisibility = this.getNameTagVisibility();
        result = result * PRIME + ($nameTagVisibility == null ? 43 : $nameTagVisibility.hashCode());
        final java.lang.Object $collisionRule = this.getCollisionRule();
        result = result * PRIME + ($collisionRule == null ? 43 : $collisionRule.hashCode());
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getPlayers());
        return result;
    }
}
