// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ServerData extends DefinedPacket {
    private BaseComponent motd;
    private Object icon;
    private boolean preview;
    private boolean enforceSecure;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_4 || buf.readBoolean()) {
            motd = readBaseComponent(buf, protocolVersion);
        }
        if (buf.readBoolean()) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_4) {
                icon = readArray(buf);
            } else {
                icon = readString(buf);
            }
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            preview = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1 && protocolVersion < ProtocolConstants.MINECRAFT_1_20_5) {
            enforceSecure = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (motd != null) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_4) {
                buf.writeBoolean(true);
            }
            writeBaseComponent(motd, buf, protocolVersion);
        } else {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_4) {
                throw new IllegalArgumentException("MOTD required for this version");
            }
            buf.writeBoolean(false);
        }
        if (icon != null) {
            buf.writeBoolean(true);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_4) {
                writeArray((byte[]) icon, buf);
            } else {
                writeString((String) icon, buf);
            }
        } else {
            buf.writeBoolean(false);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            buf.writeBoolean(preview);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1 && protocolVersion < ProtocolConstants.MINECRAFT_1_20_5) {
            buf.writeBoolean(enforceSecure);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getMotd() {
        return this.motd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getIcon() {
        return this.icon;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isPreview() {
        return this.preview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isEnforceSecure() {
        return this.enforceSecure;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMotd(final BaseComponent motd) {
        this.motd = motd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIcon(final Object icon) {
        this.icon = icon;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreview(final boolean preview) {
        this.preview = preview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnforceSecure(final boolean enforceSecure) {
        this.enforceSecure = enforceSecure;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerData(motd=" + this.getMotd() + ", icon=" + this.getIcon() + ", preview=" + this.isPreview() + ", enforceSecure=" + this.isEnforceSecure() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerData() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerData(final BaseComponent motd, final Object icon, final boolean preview, final boolean enforceSecure) {
        this.motd = motd;
        this.icon = icon;
        this.preview = preview;
        this.enforceSecure = enforceSecure;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerData)) return false;
        final ServerData other = (ServerData) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isPreview() != other.isPreview()) return false;
        if (this.isEnforceSecure() != other.isEnforceSecure()) return false;
        final java.lang.Object this$motd = this.getMotd();
        final java.lang.Object other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) return false;
        final java.lang.Object this$icon = this.getIcon();
        final java.lang.Object other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isPreview() ? 79 : 97);
        result = result * PRIME + (this.isEnforceSecure() ? 79 : 97);
        final java.lang.Object $motd = this.getMotd();
        result = result * PRIME + ($motd == null ? 43 : $motd.hashCode());
        final java.lang.Object $icon = this.getIcon();
        result = result * PRIME + ($icon == null ? 43 : $icon.hashCode());
        return result;
    }
}
