// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.NumberFormat;

public class ScoreboardScore extends DefinedPacket {
    private String itemName;
    /**
     * 0 = create / update, 1 = remove.
     */
    private byte action;
    private String scoreName;
    private int value;
    private BaseComponent displayName;
    private NumberFormat numberFormat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        itemName = readString(buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
            action = 0;
        } else {
            action = buf.readByte();
        }
        scoreName = readString(buf);
        if (action != 1) {
            value = readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
            displayName = readNullable(b -> readBaseComponent(b, protocolVersion), buf);
            numberFormat = readNullable(b -> readNumberFormat(b, protocolVersion), buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(itemName, buf);
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_20_3) {
            buf.writeByte(action);
        }
        writeString(scoreName, buf);
        if (action != 1 || protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
            writeVarInt(value, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
            writeNullable(displayName, (s, b) -> DefinedPacket.writeBaseComponent(s, b, protocolVersion), buf);
            writeNullable(numberFormat, (s, b) -> DefinedPacket.writeNumberFormat(s, b, protocolVersion), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getItemName() {
        return this.itemName;
    }

    /**
     * 0 = create / update, 1 = remove.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getAction() {
        return this.action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getScoreName() {
        return this.scoreName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getDisplayName() {
        return this.displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItemName(final String itemName) {
        this.itemName = itemName;
    }

    /**
     * 0 = create / update, 1 = remove.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAction(final byte action) {
        this.action = action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setScoreName(final String scoreName) {
        this.scoreName = scoreName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final int value) {
        this.value = value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayName(final BaseComponent displayName) {
        this.displayName = displayName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumberFormat(final NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ScoreboardScore(itemName=" + this.getItemName() + ", action=" + this.getAction() + ", scoreName=" + this.getScoreName() + ", value=" + this.getValue() + ", displayName=" + this.getDisplayName() + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScoreboardScore() {
    }

    /**
     * Creates a new {@code ScoreboardScore} instance.
     *
     * @param itemName
     * @param action 0 = create / update, 1 = remove.
     * @param scoreName
     * @param value
     * @param displayName
     * @param numberFormat
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScoreboardScore(final String itemName, final byte action, final String scoreName, final int value, final BaseComponent displayName, final NumberFormat numberFormat) {
        this.itemName = itemName;
        this.action = action;
        this.scoreName = scoreName;
        this.value = value;
        this.displayName = displayName;
        this.numberFormat = numberFormat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ScoreboardScore)) return false;
        final ScoreboardScore other = (ScoreboardScore) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getAction() != other.getAction()) return false;
        if (this.getValue() != other.getValue()) return false;
        final java.lang.Object this$itemName = this.getItemName();
        final java.lang.Object other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) return false;
        final java.lang.Object this$scoreName = this.getScoreName();
        final java.lang.Object other$scoreName = other.getScoreName();
        if (this$scoreName == null ? other$scoreName != null : !this$scoreName.equals(other$scoreName)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$numberFormat = this.getNumberFormat();
        final java.lang.Object other$numberFormat = other.getNumberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ScoreboardScore;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getAction();
        result = result * PRIME + this.getValue();
        final java.lang.Object $itemName = this.getItemName();
        result = result * PRIME + ($itemName == null ? 43 : $itemName.hashCode());
        final java.lang.Object $scoreName = this.getScoreName();
        result = result * PRIME + ($scoreName == null ? 43 : $scoreName.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $numberFormat = this.getNumberFormat();
        result = result * PRIME + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        return result;
    }
}
