// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.NumberFormat;
import net.md_5.bungee.protocol.util.Either;

public class ScoreboardObjective extends DefinedPacket {
    private String name;
    private Either<String, BaseComponent> value;
    private HealthDisplay type;
    /**
     * 0 to create, 1 to remove, 2 to update display text.
     */
    private byte action;
    private NumberFormat numberFormat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        name = readString(buf);
        action = buf.readByte();
        if (action == 0 || action == 2) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
                value = readEitherBaseComponent(buf, protocolVersion, false);
                type = HealthDisplay.values()[readVarInt(buf)];
            } else {
                value = readEitherBaseComponent(buf, protocolVersion, true);
                type = HealthDisplay.fromString(readString(buf));
            }
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
                numberFormat = readNullable(b -> readNumberFormat(b, protocolVersion), buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(name, buf);
        buf.writeByte(action);
        if (action == 0 || action == 2) {
            writeEitherBaseComponent(value, buf, protocolVersion);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_13) {
                writeVarInt(type.ordinal(), buf);
            } else {
                writeString(type.toString(), buf);
            }
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_3) {
                writeNullable(numberFormat, (s, b) -> DefinedPacket.writeNumberFormat(s, b, protocolVersion), buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public enum HealthDisplay {
        INTEGER, HEARTS;

        @Override
        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static HealthDisplay fromString(String s) {
            return valueOf(s.toUpperCase(Locale.ROOT));
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Either<String, BaseComponent> getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HealthDisplay getType() {
        return this.type;
    }

    /**
     * 0 to create, 1 to remove, 2 to update display text.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getAction() {
        return this.action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final Either<String, BaseComponent> value) {
        this.value = value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final HealthDisplay type) {
        this.type = type;
    }

    /**
     * 0 to create, 1 to remove, 2 to update display text.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAction(final byte action) {
        this.action = action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumberFormat(final NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ScoreboardObjective(name=" + this.getName() + ", value=" + this.getValue() + ", type=" + this.getType() + ", action=" + this.getAction() + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScoreboardObjective() {
    }

    /**
     * Creates a new {@code ScoreboardObjective} instance.
     *
     * @param name
     * @param value
     * @param type
     * @param action 0 to create, 1 to remove, 2 to update display text.
     * @param numberFormat
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScoreboardObjective(final String name, final Either<String, BaseComponent> value, final HealthDisplay type, final byte action, final NumberFormat numberFormat) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.action = action;
        this.numberFormat = numberFormat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ScoreboardObjective)) return false;
        final ScoreboardObjective other = (ScoreboardObjective) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getAction() != other.getAction()) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$numberFormat = this.getNumberFormat();
        final java.lang.Object other$numberFormat = other.getNumberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ScoreboardObjective;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getAction();
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $numberFormat = this.getNumberFormat();
        result = result * PRIME + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        return result;
    }
}
