// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.PlayerPublicKey;
import net.md_5.bungee.protocol.data.Property;

public class PlayerListItem extends DefinedPacket {
    private Action action;
    private Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        action = Action.values()[DefinedPacket.readVarInt(buf)];
        items = new Item[DefinedPacket.readVarInt(buf)];
        for (int i = 0; i < items.length; i++) {
            Item item = items[i] = new Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            switch (action) {
            case ADD_PLAYER: 
                item.username = DefinedPacket.readString(buf);
                item.properties = DefinedPacket.readProperties(buf);
                item.gamemode = DefinedPacket.readVarInt(buf);
                item.ping = DefinedPacket.readVarInt(buf);
                if (buf.readBoolean()) {
                    item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                }
                if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
                    item.publicKey = readPublicKey(buf);
                }
                break;
            case UPDATE_GAMEMODE: 
                item.gamemode = DefinedPacket.readVarInt(buf);
                break;
            case UPDATE_LATENCY: 
                item.ping = DefinedPacket.readVarInt(buf);
                break;
            case UPDATE_DISPLAY_NAME: 
                if (buf.readBoolean()) {
                    item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeVarInt(action.ordinal(), buf);
        DefinedPacket.writeVarInt(items.length, buf);
        for (Item item : items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            switch (action) {
            case ADD_PLAYER: 
                DefinedPacket.writeString(item.username, buf);
                DefinedPacket.writeProperties(item.properties, buf);
                DefinedPacket.writeVarInt(item.gamemode, buf);
                DefinedPacket.writeVarInt(item.ping, buf);
                buf.writeBoolean(item.displayName != null);
                if (item.displayName != null) {
                    DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                }
                if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19) {
                    writePublicKey(item.publicKey, buf);
                }
                break;
            case UPDATE_GAMEMODE: 
                DefinedPacket.writeVarInt(item.gamemode, buf);
                break;
            case UPDATE_LATENCY: 
                DefinedPacket.writeVarInt(item.ping, buf);
                break;
            case UPDATE_DISPLAY_NAME: 
                buf.writeBoolean(item.displayName != null);
                if (item.displayName != null) {
                    DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                }
                break;
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public static enum Action {
        ADD_PLAYER, UPDATE_GAMEMODE, UPDATE_LATENCY, UPDATE_DISPLAY_NAME, REMOVE_PLAYER;
    }


    public static class Item {
        // ALL
        UUID uuid;
        // ADD_PLAYER
        String username;
        Property[] properties;
        UUID chatSessionId;
        PlayerPublicKey publicKey;
        // UPDATE_LISTED
        Boolean listed;
        // ADD_PLAYER & UPDATE_GAMEMODE
        Integer gamemode;
        // ADD_PLAYER & UPDATE_LATENCY
        Integer ping;
        // ADD_PLAYER & UPDATE_DISPLAY_NAME
        BaseComponent displayName;
        // UPDATE_LIST_ORDER 1.21.2
        Integer listOrder;
        // UPDATE_HAT 1.21.4
        Boolean showHat;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Item() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUsername() {
            return this.username;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Property[] getProperties() {
            return this.properties;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UUID getChatSessionId() {
            return this.chatSessionId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PlayerPublicKey getPublicKey() {
            return this.publicKey;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getListed() {
            return this.listed;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getGamemode() {
            return this.gamemode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getPing() {
            return this.ping;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public BaseComponent getDisplayName() {
            return this.displayName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getListOrder() {
            return this.listOrder;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getShowHat() {
            return this.showHat;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUuid(final UUID uuid) {
            this.uuid = uuid;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUsername(final String username) {
            this.username = username;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setProperties(final Property[] properties) {
            this.properties = properties;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setChatSessionId(final UUID chatSessionId) {
            this.chatSessionId = chatSessionId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPublicKey(final PlayerPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setListed(final Boolean listed) {
            this.listed = listed;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setGamemode(final Integer gamemode) {
            this.gamemode = gamemode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPing(final Integer ping) {
            this.ping = ping;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDisplayName(final BaseComponent displayName) {
            this.displayName = displayName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setListOrder(final Integer listOrder) {
            this.listOrder = listOrder;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setShowHat(final Boolean showHat) {
            this.showHat = showHat;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof PlayerListItem.Item)) return false;
            final PlayerListItem.Item other = (PlayerListItem.Item) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$listed = this.getListed();
            final java.lang.Object other$listed = other.getListed();
            if (this$listed == null ? other$listed != null : !this$listed.equals(other$listed)) return false;
            final java.lang.Object this$gamemode = this.getGamemode();
            final java.lang.Object other$gamemode = other.getGamemode();
            if (this$gamemode == null ? other$gamemode != null : !this$gamemode.equals(other$gamemode)) return false;
            final java.lang.Object this$ping = this.getPing();
            final java.lang.Object other$ping = other.getPing();
            if (this$ping == null ? other$ping != null : !this$ping.equals(other$ping)) return false;
            final java.lang.Object this$listOrder = this.getListOrder();
            final java.lang.Object other$listOrder = other.getListOrder();
            if (this$listOrder == null ? other$listOrder != null : !this$listOrder.equals(other$listOrder)) return false;
            final java.lang.Object this$showHat = this.getShowHat();
            final java.lang.Object other$showHat = other.getShowHat();
            if (this$showHat == null ? other$showHat != null : !this$showHat.equals(other$showHat)) return false;
            final java.lang.Object this$uuid = this.getUuid();
            final java.lang.Object other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) return false;
            final java.lang.Object this$username = this.getUsername();
            final java.lang.Object other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
            if (!java.util.Arrays.deepEquals(this.getProperties(), other.getProperties())) return false;
            final java.lang.Object this$chatSessionId = this.getChatSessionId();
            final java.lang.Object other$chatSessionId = other.getChatSessionId();
            if (this$chatSessionId == null ? other$chatSessionId != null : !this$chatSessionId.equals(other$chatSessionId)) return false;
            final java.lang.Object this$publicKey = this.getPublicKey();
            final java.lang.Object other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof PlayerListItem.Item;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $listed = this.getListed();
            result = result * PRIME + ($listed == null ? 43 : $listed.hashCode());
            final java.lang.Object $gamemode = this.getGamemode();
            result = result * PRIME + ($gamemode == null ? 43 : $gamemode.hashCode());
            final java.lang.Object $ping = this.getPing();
            result = result * PRIME + ($ping == null ? 43 : $ping.hashCode());
            final java.lang.Object $listOrder = this.getListOrder();
            result = result * PRIME + ($listOrder == null ? 43 : $listOrder.hashCode());
            final java.lang.Object $showHat = this.getShowHat();
            result = result * PRIME + ($showHat == null ? 43 : $showHat.hashCode());
            final java.lang.Object $uuid = this.getUuid();
            result = result * PRIME + ($uuid == null ? 43 : $uuid.hashCode());
            final java.lang.Object $username = this.getUsername();
            result = result * PRIME + ($username == null ? 43 : $username.hashCode());
            result = result * PRIME + java.util.Arrays.deepHashCode(this.getProperties());
            final java.lang.Object $chatSessionId = this.getChatSessionId();
            result = result * PRIME + ($chatSessionId == null ? 43 : $chatSessionId.hashCode());
            final java.lang.Object $publicKey = this.getPublicKey();
            result = result * PRIME + ($publicKey == null ? 43 : $publicKey.hashCode());
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PlayerListItem.Item(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + java.util.Arrays.deepToString(this.getProperties()) + ", chatSessionId=" + this.getChatSessionId() + ", publicKey=" + this.getPublicKey() + ", listed=" + this.getListed() + ", gamemode=" + this.getGamemode() + ", ping=" + this.getPing() + ", displayName=" + this.getDisplayName() + ", listOrder=" + this.getListOrder() + ", showHat=" + this.getShowHat() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Action getAction() {
        return this.action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Item[] getItems() {
        return this.items;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAction(final Action action) {
        this.action = action;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItems(final Item[] items) {
        this.items = items;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PlayerListItem(action=" + this.getAction() + ", items=" + java.util.Arrays.deepToString(this.getItems()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PlayerListItem() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PlayerListItem)) return false;
        final PlayerListItem other = (PlayerListItem) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$action = this.getAction();
        final java.lang.Object other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
        if (!java.util.Arrays.deepEquals(this.getItems(), other.getItems())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PlayerListItem;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $action = this.getAction();
        result = result * PRIME + ($action == null ? 43 : $action.hashCode());
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getItems());
        return result;
    }
}
