// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.OverflowPacketException;

public class LoginPayloadRequest extends DefinedPacket {
    private int id;
    private String channel;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        id = readVarInt(buf);
        channel = readString(buf);
        int len = buf.readableBytes();
        if (len > 1048576) {
            throw new OverflowPacketException("Payload may not be larger than 1048576 bytes");
        }
        data = new byte[len];
        buf.readBytes(data);
    }

    @Override
    public void write(ByteBuf buf) {
        writeVarInt(id, buf);
        writeString(channel, buf);
        buf.writeBytes(data);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getId() {
        return this.id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getChannel() {
        return this.channel;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getData() {
        return this.data;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final int id) {
        this.id = id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChannel(final String channel) {
        this.channel = channel;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setData(final byte[] data) {
        this.data = data;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LoginPayloadRequest(id=" + this.getId() + ", channel=" + this.getChannel() + ", data=" + java.util.Arrays.toString(this.getData()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginPayloadRequest() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginPayloadRequest(final int id, final String channel, final byte[] data) {
        this.id = id;
        this.channel = channel;
        this.data = data;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LoginPayloadRequest)) return false;
        final LoginPayloadRequest other = (LoginPayloadRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getId() != other.getId()) return false;
        final java.lang.Object this$channel = this.getChannel();
        final java.lang.Object other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) return false;
        if (!java.util.Arrays.equals(this.getData(), other.getData())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LoginPayloadRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getId();
        final java.lang.Object $channel = this.getChannel();
        result = result * PRIME + ($channel == null ? 43 : $channel.hashCode());
        result = result * PRIME + java.util.Arrays.hashCode(this.getData());
        return result;
    }
}
