// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class Handshake extends DefinedPacket {
    private int protocolVersion;
    private String host;
    private int port;
    private int requestedProtocol;

    @Override
    public void read(ByteBuf buf) {
        protocolVersion = readVarInt(buf);
        host = readString(buf, 255);
        port = buf.readUnsignedShort();
        requestedProtocol = readVarInt(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        writeVarInt(protocolVersion, buf);
        writeString(host, buf);
        buf.writeShort(port);
        writeVarInt(requestedProtocol, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHost() {
        return this.host;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getPort() {
        return this.port;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getRequestedProtocol() {
        return this.requestedProtocol;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProtocolVersion(final int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHost(final String host) {
        this.host = host;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPort(final int port) {
        this.port = port;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequestedProtocol(final int requestedProtocol) {
        this.requestedProtocol = requestedProtocol;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Handshake(protocolVersion=" + this.getProtocolVersion() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", requestedProtocol=" + this.getRequestedProtocol() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Handshake() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Handshake(final int protocolVersion, final String host, final int port, final int requestedProtocol) {
        this.protocolVersion = protocolVersion;
        this.host = host;
        this.port = port;
        this.requestedProtocol = requestedProtocol;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Handshake)) return false;
        final Handshake other = (Handshake) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getProtocolVersion() != other.getProtocolVersion()) return false;
        if (this.getPort() != other.getPort()) return false;
        if (this.getRequestedProtocol() != other.getRequestedProtocol()) return false;
        final java.lang.Object this$host = this.getHost();
        final java.lang.Object other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Handshake;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getProtocolVersion();
        result = result * PRIME + this.getPort();
        result = result * PRIME + this.getRequestedProtocol();
        final java.lang.Object $host = this.getHost();
        result = result * PRIME + ($host == null ? 43 : $host.hashCode());
        return result;
    }
}
